/*
 * Decompiled with CFR 0.152.
 */
package amida.node;

import amida.node.BlockNode;
import amida.node.CallNode;
import amida.node.Node;
import amida.node.NodeIterator;
import amida.node.NodeList;

public class TopRecursiveBlockNode
extends BlockNode {
    private NodeList hiddenList;
    private NodeList representList;
    private boolean isFold = true;

    public TopRecursiveBlockNode(CallNode represent, CallNode brind) {
        super(represent.getCallTree());
        this.representList = new NodeList(this, represent.getCallTree());
        this.representList.add(represent);
        represent.setParent(this);
        this.hiddenList = new NodeList(this, represent.getCallTree());
        this.hiddenList.add(brind);
        brind.setParent(this);
    }

    public Object clone() throws CloneNotSupportedException {
        TopRecursiveBlockNode copy = (TopRecursiveBlockNode)super.clone();
        NodeList newRepresentList = new NodeList(copy, this.getCallTree());
        newRepresentList.add(this.representList.get(0));
        copy.representList = newRepresentList;
        NodeList newHiddenList = new NodeList(copy, this.getCallTree());
        newHiddenList.add(this.hiddenList.get(0));
        copy.hiddenList = newHiddenList;
        return copy;
    }

    public CallNode getRepresentChild() {
        return (CallNode)this.getRepresentChildren().get(0);
    }

    public CallNode getHiddenChild() {
        return (CallNode)this.getHiddenChildren().get(0);
    }

    public void setFold(boolean bool) {
        this.isFold = bool;
    }

    public boolean isFold() {
        return this.isFold;
    }

    public NodeList getChildren() {
        if (this.isBehind()) {
            return super.getChildren();
        }
        if (this.isFold()) {
            return this.getRepresentChildren();
        }
        return this.getHiddenChildren();
    }

    public NodeList getRepresentChildren() {
        return this.representList;
    }

    public NodeList getHiddenChildren() {
        return this.hiddenList;
    }

    public CallNode getCallNode(int index) {
        if (index != 0) {
            return null;
        }
        if (this.isFold()) {
            return this.getRepresentChild();
        }
        return this.getHiddenChild();
    }

    public int getCallNodeNum() {
        return 1;
    }

    public void addChild(Node node) {
        if (node instanceof CallNode) {
            this.setRepresentList((CallNode)node);
        }
    }

    public void setRepresentList(CallNode call) {
        this.representList.set(0, call);
    }

    public boolean hasChildren() {
        return !this.isBehind();
    }

    public NodeIterator nodeIterator() {
        if (this.isBehind()) {
            return super.nodeIterator();
        }
        if (this.isFold) {
            return this.getRepresentChildren().nodeIterator();
        }
        return this.getHiddenChildren().nodeIterator();
    }

    public void removeAllChildren() {
    }

    public String toString() {
        if (this.isFold) {
            return this.getRepresentChild().toString();
        }
        return this.getHiddenChild().toString();
    }

    public Node getNewInstance() {
        try {
            CallNode rep = (CallNode)this.getRepresentChild().clone();
            CallNode hid = (CallNode)this.getHiddenChild().clone();
            return new TopRecursiveBlockNode(rep, hid);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public NodeList getAllChildren() {
        if (this.isFold) {
            return this.getRepresentChildren();
        }
        return this.getHiddenChildren();
    }

    public NodeList getBehindChildren() {
        if (this.isBehind()) {
            return this.getAllChildren();
        }
        return super.getBehindChildren();
    }
}

