/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler.gui;

import amida.node.CallTree;
import amida.node.CallTreeManager;
import amida.profiler.LogFile;
import amida.sequencer.SequenceModel;
import amida.sequencer.gui.MainFrame;
import amida.sequencer.gui.SequenceDiagramTabbedPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LogChooser
extends JTable {
    public LogChooser(TableModel model) {
        super(model);
        this.setSelectionMode(0);
        TableColumn column0 = this.getColumnModel().getColumn(0);
        column0.setHeaderValue("logfile");
        column0.setWidth(200);
        column0.setPreferredWidth(200);
        TableColumn column1 = this.getColumnModel().getColumn(1);
        column1.setHeaderValue("methods");
        column1.setWidth(100);
        column1.setPreferredWidth(100);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = LogChooser.this.getSelectedRow();
                    File logFile = ((LogFile)LogChooser.this.getValueAt(index, 0)).getFile();
                    CallTree callTree = CallTreeManager.getInstance().makeCallTree(logFile);
                    if (callTree == null) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "", "File format error.", 0);
                        return;
                    }
                    SequenceModel model = new SequenceModel(callTree);
                    SequenceDiagramTabbedPane.getInstance().addNewDiagram(model, logFile.getName());
                }
            }
        });
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

