/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer;

import amida.node.CallNode;
import amida.sequencer.Called;
import amida.sequencer.ISequenceElement;
import amida.sequencer.Sequence;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class SequenceObject
implements ISequenceElement {
    public static final int APPEARANCE = 0;
    public static final int CLASS_NAME = 1;
    public static final int ID = 2;
    private int index;
    private int madeIndex;
    private int lastUsedIndex;
    private int appearanceNum;
    private String className;
    private String packageName;
    private Set ids = new TreeSet();
    private List calledList = new ArrayList();
    private final Stack callStack = new Stack();
    private final List calledSequences = new LinkedList();
    private final List callSequences = new LinkedList();
    private boolean renewable = true;

    public SequenceObject(CallNode call) {
        this.renewClassName(call);
        this.ids.addAll(call.getId());
    }

    public void renewClassName(CallNode call) {
        if (this.renewable) {
            this.className = call.getClassName();
            this.packageName = call.getPackageName();
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void addId(int i) {
        this.ids.add(new Integer(i));
    }

    public void addId(Integer i) {
        this.ids.add(i);
    }

    public void addIds(Set ids) {
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            this.ids.add(o);
        }
    }

    public Set getIds() {
        return this.ids;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void call(Sequence seq, int start) {
        this.callStack.push(new Integer(start));
        this.calledSequences.add(seq);
    }

    public void ret(Sequence seq, int end) {
        Integer start = (Integer)this.callStack.pop();
        this.calledList.add(new Called(this, seq.getPareSequence(), seq, start, end, this.callStack.size()));
        this.calledSequences.add(seq);
    }

    public void addCallSequence(Sequence seq) {
        this.callSequences.add(seq);
    }

    public int getCalledNum() {
        return this.calledList.size();
    }

    public Called getCalled(int index) {
        return (Called)this.calledList.get(index);
    }

    public int getLevel() {
        return this.callStack.size();
    }

    public void make(int index) {
        this.madeIndex = index;
    }

    public int getMadeIndex() {
        return this.madeIndex;
    }

    public void used(int index) {
        this.lastUsedIndex = index;
    }

    public int getLastUsedIndex() {
        return this.lastUsedIndex;
    }

    public int getAppearanceNum() {
        return this.appearanceNum;
    }

    public boolean isArraive(int start, int end) {
        return end >= this.madeIndex && start <= this.lastUsedIndex;
    }

    public boolean isEnded(int index) {
        return index <= this.lastUsedIndex;
    }

    public void setAppearanceIndex(int i) {
        this.appearanceNum = i;
        this.index = i;
    }

    public void setPackageName(String packageName) {
        if (this.renewable) {
            this.packageName = packageName;
        }
    }

    public void setClassName(String className) {
        if (this.renewable) {
            this.className = className;
        }
    }

    public void setRenewable(boolean b) {
        this.renewable = b;
    }

    public class PackageNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof SequenceObject) || !(o2 instanceof SequenceObject)) {
                return -1;
            }
            SequenceObject so1 = (SequenceObject)o1;
            SequenceObject so2 = (SequenceObject)o2;
            return so1.getPackageName().compareTo(so2.getPackageName());
        }
    }

    public class ClassNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof SequenceObject) || !(o2 instanceof SequenceObject)) {
                return -1;
            }
            SequenceObject so1 = (SequenceObject)o1;
            SequenceObject so2 = (SequenceObject)o2;
            return so1.getClassName().compareTo(so2.getClassName());
        }
    }

    public class PackageClassNameComparator
    implements Comparator {
        private PackageNameComparator packageComparator;
        private ClassNameComparator classComparator;

        public PackageClassNameComparator() {
            this.packageComparator = new PackageNameComparator();
            this.classComparator = new ClassNameComparator();
        }

        public int compare(Object o1, Object o2) {
            int packageResult = this.packageComparator.compare(o1, o2);
            if (packageResult != 0) {
                return packageResult;
            }
            return this.classComparator.compare(o1, o2);
        }
    }

    public class FirstIdComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof SequenceObject) || !(o2 instanceof SequenceObject)) {
                return -1;
            }
            int id1 = (Integer)((SequenceObject)o1).getIds().iterator().next();
            int id2 = (Integer)((SequenceObject)o2).getIds().iterator().next();
            return id1 - id2;
        }
    }

    public class AppearanceIndexComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof SequenceObject) || !(o2 instanceof SequenceObject)) {
                return -1;
            }
            int id1 = ((SequenceObject)o1).getAppearanceNum();
            int id2 = ((SequenceObject)o2).getAppearanceNum();
            return id1 - id2;
        }
    }
}

