/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.library.MyFileFilter;
import amida.library.ProgressDialog;
import amida.library.ProgressListener;
import amida.logcompactor.LoopCompactorThread;
import amida.logcompactor.RecursiveCallCompactorThread;
import amida.logcompactor.foldrule.MethodMissingLoopRule;
import amida.logcompactor.foldrule.ObjectDifferenceLoopRule;
import amida.logcompactor.foldrule.SimpleLoopRule;
import amida.logcompactor.gui.LogTextAreaFrame;
import amida.logcompactor.gui.WorkingSetFrame;
import amida.logseparator.Separator;
import amida.node.BlockNode;
import amida.node.CallNode;
import amida.node.CallTree;
import amida.node.CallTreeManager;
import amida.node.Node;
import amida.node.NodeIterator;
import amida.node.NodeList;
import amida.node.comparator.NodeTreeComparator;
import amida.profiler.gui.ProfileDialog;
import amida.sequencefilter.gui.FilterDialog;
import amida.sequencer.SequenceModel;
import amida.sequencer.gui.InformationTabbedPane;
import amida.sequencer.gui.SearchDialog;
import amida.sequencer.gui.SequenceDiagramPanel;
import amida.sequencer.gui.SequenceDiagramTabbedPane;
import amida.sequencer.gui.SequenceMapCanvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class MainFrame
extends JFrame {
    private final ProgressDialog progressDialog;
    private final SearchDialog searchDialog = new SearchDialog();
    private final WorkingSetFrame wf = new WorkingSetFrame("Prot Window");
    private final LogTextAreaFrame logWindow = new LogTextAreaFrame();
    private final InformationTabbedPane informationTab = InformationTabbedPane.getInstance();
    private final SequenceDiagramTabbedPane diagramTab = SequenceDiagramTabbedPane.getInstance();
    private final SequenceMapCanvas mapCanvas = SequenceMapCanvas.getInstance();
    private double diagramWidthRate = 0.9;
    private double diagramHeigthRate = 0.85;
    private static final MainFrame singleton = new MainFrame();

    private MainFrame() {
        super("Amida");
        this.progressDialog = new ProgressDialog(this);
        JSplitPane informationSplit = new JSplitPane();
        informationSplit.setOrientation(0);
        informationSplit.setDividerSize(2);
        informationSplit.setLeftComponent(this.diagramTab);
        informationSplit.setRightComponent(this.informationTab);
        JScrollPane mapScroll = new JScrollPane(this.mapCanvas);
        this.mapCanvas.setScrollPane(mapScroll);
        JSplitPane mapSplit = new JSplitPane();
        mapSplit.setDividerSize(2);
        mapSplit.setLeftComponent(informationSplit);
        mapSplit.setRightComponent(mapScroll);
        Dimension screenSize = this.getToolkit().getScreenSize();
        screenSize.setSize(screenSize.getWidth() - 15.0, screenSize.getHeight() - 90.0);
        this.diagramTab.setPreferredSize(new Dimension((int)(screenSize.getWidth() * this.diagramWidthRate), (int)(screenSize.getHeight() * this.diagramHeigthRate)));
        this.informationTab.setPreferredSize(new Dimension((int)(screenSize.getWidth() * this.diagramWidthRate), (int)(screenSize.getHeight() * (1.0 - this.diagramHeigthRate))));
        this.mapCanvas.setPreferredSize(new Dimension((int)(screenSize.getWidth() * (1.0 - this.diagramWidthRate)), (int)screenSize.getHeight()));
        informationSplit.resetToPreferredSizes();
        mapSplit.resetToPreferredSizes();
        Container cp = this.getContentPane();
        cp.add(mapSplit);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem saveMenuItem = new JMenuItem("Save");
        JMenuItem loadMenuItem = new JMenuItem("Load");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        fileMenu.add(loadMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(exitMenuItem);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        JMenu sortMenu = new JMenu("Sort");
        editMenu.add(sortMenu);
        JMenuItem sortAppearIndex = new JMenuItem("appearance index");
        sortMenu.add(sortAppearIndex);
        JMenuItem sortClassName = new JMenuItem("class name");
        sortMenu.add(sortClassName);
        JMenuItem sortId = new JMenuItem("object id");
        sortMenu.add(sortId);
        menuBar.add(editMenu);
        JMenu conpactionMenu = new JMenu("Compression");
        JMenuItem foldMenuItem = new JMenuItem("Simple loop");
        conpactionMenu.add(foldMenuItem);
        conpactionMenu.addSeparator();
        JMenuItem anotherObjectMenuItem = new JMenuItem("Object difference loop");
        conpactionMenu.add(anotherObjectMenuItem);
        conpactionMenu.addSeparator();
        JMenuItem includeLoopMenuItem = new JMenuItem("Method missing loop");
        conpactionMenu.add(includeLoopMenuItem);
        conpactionMenu.addSeparator();
        JMenuItem recursiveMenuItem = new JMenuItem("Recursive call");
        conpactionMenu.add(recursiveMenuItem);
        editMenu.add(conpactionMenu);
        JMenuItem searchMenuItem = new JMenuItem("Search");
        editMenu.add(searchMenuItem);
        JMenuItem separateMenuItem = new JMenuItem("Separate");
        editMenu.add(separateMenuItem);
        JMenuItem filterMenuItem = new JMenuItem("Filter");
        editMenu.add(filterMenuItem);
        JMenu profileMenu = new JMenu("Profile");
        JMenuItem profileAsMenuItem = new JMenuItem("Profile as ...");
        profileMenu.add(profileAsMenuItem);
        menuBar.add(profileMenu);
        JMenu windowMenu = new JMenu("Window");
        JMenuItem printWorkingSetItem = new JMenuItem("Method prot");
        windowMenu.add(printWorkingSetItem);
        JMenuItem logWindowItem = new JMenuItem("Trace Log");
        windowMenu.add(logWindowItem);
        menuBar.add(windowMenu);
        JMenu debugMenu = new JMenu("Debug");
        JMenuItem newFunctionTestItem = new JMenuItem("New function test");
        debugMenu.add(newFunctionTestItem);
        menuBar.add(debugMenu);
        this.setJMenuBar(menuBar);
        loadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(".");
                fileChooser.setFileFilter(new MyFileFilter(new String[]{"txt", "log"}));
                if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                    CallTree callTree;
                    File logFile = new File(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFile().getName());
                    if (CallTreeManager.getInstance().getCallTreeNum() > 0) {
                        CallTreeManager.getInstance().clearIdMap();
                    }
                    if ((callTree = CallTreeManager.getInstance().makeCallTree(logFile)) == null) {
                        JOptionPane.showMessageDialog(MainFrame.this, "File format error.", "Error.", 0);
                        return;
                    }
                    SequenceModel model = new SequenceModel(callTree);
                    MainFrame.this.diagramTab.addNewDiagram(model, logFile.getName());
                }
            }
        });
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        foldMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                LoopCompactorThread thread = new LoopCompactorThread(new SimpleLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.access$1(3.access$0(this.this$1)).setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }

            static /* synthetic */ MainFrame access$0(3 var0) {
                return var0.MainFrame.this;
            }
        });
        anotherObjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                LoopCompactorThread thread = new LoopCompactorThread(new ObjectDifferenceLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.access$1(5.access$0(this.this$1)).setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }

            static /* synthetic */ MainFrame access$0(5 var0) {
                return var0.MainFrame.this;
            }
        });
        includeLoopMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                LoopCompactorThread thread = new LoopCompactorThread(new MethodMissingLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.access$1(7.access$0(this.this$1)).setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }

            static /* synthetic */ MainFrame access$0(7 var0) {
                return var0.MainFrame.this;
            }
        });
        recursiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                SequenceModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                NodeTreeComparator.compareNotEndedNode = true;
                RecursiveCallCompactorThread thread = new RecursiveCallCompactorThread(model.getCallTree());
                thread.addProgressListener(MainFrame.this.progressDialog);
                thread.addProgressListener(new ProgressListener(this){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void progress(int value, int max) {
                        if (value == max) {
                            MainFrame.access$1(9.access$0(this.this$1)).setVisible(false);
                        }
                    }
                });
                thread.start();
                MainFrame.this.progressDialog.setVisible(true);
            }

            static /* synthetic */ MainFrame access$0(9 var0) {
                return var0.MainFrame.this;
            }
        });
        printWorkingSetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MainFrame.this.wf.prot();
                MainFrame.this.wf.pack();
                MainFrame.this.wf.setVisible(true);
                MainFrame.this.wf.repaint();
            }
        });
        logWindowItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.logWindow.setVisible(true);
            }
        });
        profileAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ProfileDialog.getInstance().setVisible(true);
            }
        });
        searchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MainFrame.this.searchDialog.setVisible(true);
            }
        });
        separateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.diagramTab.getSelectedDiagram() == null) {
                    return;
                }
                Separator separator = new Separator();
                SequenceModel model = MainFrame.this.diagramTab.getSelectedDiagram().getModel();
                CallTree tree = model.getCallTree();
                List separatedBlocks = separator.separateCallTree(tree);
                if (separatedBlocks == null) {
                    return;
                }
                ListIterator it = separatedBlocks.listIterator();
                while (it.hasNext()) {
                    BlockNode block = (BlockNode)it.next();
                    block.setBehind(true);
                    SequenceModel newModel = new SequenceModel(block.getBehindChildren());
                    String blockName = block.getBlockName();
                    if (blockName == null || blockName.equals("")) {
                        NodeIterator nit = block.getBehindChildren().nodeIterator();
                        while (nit.hasNext()) {
                            Node node = nit.nextNode();
                            CallNode call = null;
                            try {
                                call = node.getCallNode(0);
                                blockName = call.getMethodName();
                                break;
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                    }
                    MainFrame.this.diagramTab.addNewDiagram(newModel, blockName);
                }
                tree.fireDataChange();
            }
        });
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialog.getInstance().setVisible(true);
            }
        });
        newFunctionTestItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter("graphviz.txt"));
                    SequenceDiagramPanel diagram = SequenceDiagramTabbedPane.getInstance().getSelectedDiagram();
                    if (diagram != null) {
                        CallTree tree = diagram.getModel().getCallTree();
                        NodeList list = diagram.getModel().getTargetNodeList();
                        Node node = diagram.getModel().getTargetNode();
                        HashSet c = new HashSet();
                        bw.write("digraph G {");
                        bw.newLine();
                        bw.append("graph [ rankdir = \"LR\"];");
                        bw.newLine();
                        if (node != null) {
                            MainFrame.this.graphvizTest(node.getChildren(), c);
                        } else if (list != null) {
                            MainFrame.this.graphvizTest(list, c);
                        } else {
                            MainFrame.this.graphvizTest(tree.getTopNodeList(), c);
                        }
                        Iterator it = c.iterator();
                        while (it.hasNext()) {
                            bw.write(it.next().toString());
                            bw.newLine();
                        }
                        bw.write("}");
                        bw.flush();
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void graphvizTest(NodeList list, Collection c) {
        NodeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!(node instanceof CallNode) || ((CallNode)node).getCallParent() == null) {
                this.graphvizTest(node.getChildren(), c);
                continue;
            }
            CallNode call = (CallNode)node;
            CallNode parent = call.getCallParent();
            StringBuffer buffer = new StringBuffer();
            buffer.append("\"" + parent.getFullClassName() + parent.getId().toString() + "\"");
            buffer.append(" -> ");
            buffer.append("\"" + call.getFullClassName() + call.getId().toString() + "\"");
            c.add(buffer.toString().intern());
            this.graphvizTest(node.getChildren(), c);
        }
    }

    public static MainFrame getInstance() {
        return singleton;
    }
}

