/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.sequencer.gui.MainFrame;
import amida.sequencer.gui.SequenceDiagramPanel;
import amida.sequencer.gui.SequenceDiagramTabbedPane;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SearchDialog
extends JDialog {
    private final JFrame frame;
    private final JTextField keyField;
    private final JRadioButton downButton;
    private final JRadioButton upButton;
    private final JRadioButton methodButton;
    private final JRadioButton objectButton;

    public SearchDialog() {
        super((Frame)MainFrame.getInstance(), "Search");
        this.setResizable(false);
        this.frame = MainFrame.getInstance();
        this.setSize(new Dimension(400, 200));
        this.setDefaultCloseOperation(1);
        Container cp = this.getContentPane();
        JPanel keyPanel = new JPanel();
        keyPanel.setBorder(BorderFactory.createTitledBorder("Find"));
        this.keyField = new JTextField(20);
        keyPanel.add(this.keyField);
        JPanel targetPanel = new JPanel();
        targetPanel.setBorder(BorderFactory.createTitledBorder("Target"));
        targetPanel.setLayout(new FlowLayout(0));
        this.methodButton = new JRadioButton("Method", true);
        this.objectButton = new JRadioButton("Object");
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.methodButton);
        group2.add(this.objectButton);
        targetPanel.add(this.methodButton);
        targetPanel.add(this.objectButton);
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        directionPanel.setLayout(new FlowLayout(0));
        this.downButton = new JRadioButton("down", true);
        this.upButton = new JRadioButton("up");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.downButton);
        group1.add(this.upButton);
        directionPanel.add(this.downButton);
        directionPanel.add(this.upButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton serchButton = new JButton("Search");
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(serchButton);
        buttonPanel.add(cancelButton);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cp.setLayout(gb);
        cons.anchor = 18;
        cons.gridx = 0;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        gb.setConstraints(keyPanel, cons);
        cp.add(keyPanel);
        gb.setConstraints(targetPanel, cons);
        cp.add(targetPanel);
        gb.setConstraints(directionPanel, cons);
        cp.add(directionPanel);
        gb.setConstraints(buttonPanel, cons);
        cp.add(buttonPanel);
        this.pack();
        serchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!SearchDialog.this.keyField.getText().equals("")) {
                    SequenceDiagramPanel diagram = SequenceDiagramTabbedPane.getInstance().getSelectedDiagram();
                    if (diagram == null) {
                        return;
                    }
                    int target = SearchDialog.this.methodButton.isSelected() ? 0 : 1;
                    int direction = SearchDialog.this.downButton.isSelected() ? 0 : 1;
                    diagram.search(SearchDialog.this.keyField.getText(), target, direction);
                }
                SearchDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SearchDialog.this.setVisible(false);
                MainFrame.getInstance().requestFocusInWindow();
            }
        });
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.frame);
        }
        super.setVisible(b);
    }
}

