/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.library.DataChangeListener;
import amida.library.SelectionChangeListener;
import amida.node.LoopNode;
import amida.node.MethodMissingLoopNode;
import amida.node.ObjectDifferenceLoopNode;
import amida.node.SimpleLoopNode;
import amida.sequencer.Called;
import amida.sequencer.ISequenceElement;
import amida.sequencer.Sequence;
import amida.sequencer.SequenceBlock;
import amida.sequencer.SequenceLoop;
import amida.sequencer.SequenceModel;
import amida.sequencer.SequenceObject;
import amida.sequencer.gui.SelectableElement;
import amida.sequencer.gui.SequenceDiagramsAdjuster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class SequenceDiagramCanvas
extends JPanel
implements DataChangeListener,
SelectionChangeListener {
    private static final String BRANCH_MARK = "? ";
    private static final int BLOCK_TAG_WIDTH = SequenceDiagramsAdjuster.OBJECT_WIDTH;
    private static int objectsSpace = SequenceDiagramsAdjuster.MINIMUM_OBJECTS_SPACE;
    private static final Color selectionColor = new Color(204, 204, 255);
    private SequenceModel model;
    private static boolean allClassName = false;
    private SequenceDiagramsAdjuster adjuster;
    private JScrollBar verticalBar;
    private JScrollBar horizontalBar;
    private List selectablePriorityList = new ArrayList();
    private String prevSerchText;
    private int prevDirection = 0;
    private Point prevMousePressPoint = null;
    private boolean mouseDragged = false;

    public SequenceDiagramCanvas() {
        this.setBackground(Color.white);
        int i = 0;
        while (i < 5) {
            this.selectablePriorityList.add(new TreeSet());
            ++i;
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                Iterator listIt = SequenceDiagramCanvas.this.selectablePriorityList.iterator();
                while (listIt.hasNext()) {
                    Iterator elementIt = ((Collection)listIt.next()).iterator();
                    while (elementIt.hasNext()) {
                        SelectableElement element = (SelectableElement)elementIt.next();
                        if (!element.isInRange(p)) continue;
                        ISequenceElement sequenceElement = element.getElement();
                        if (e.getButton() == 1) {
                            if (e.getClickCount() == 2) {
                                if (sequenceElement instanceof SequenceLoop) {
                                    SequenceLoop loop = (SequenceLoop)sequenceElement;
                                    loop.getNode().setFold(!loop.getNode().isFold());
                                    SequenceDiagramCanvas.this.model.renew();
                                    return;
                                }
                                if (sequenceElement instanceof Called) {
                                    Called called = (Called)sequenceElement;
                                    called.getCallSequence().getNode().setBehind(!called.getCallSequence().getNode().isBehind());
                                    SequenceDiagramCanvas.this.model.renew();
                                    return;
                                }
                                if (sequenceElement instanceof SequenceBlock) {
                                    SequenceBlock block = (SequenceBlock)sequenceElement;
                                    block.getBlockNode().setBehind(!block.getBlockNode().isBehind());
                                    SequenceDiagramCanvas.this.model.renew();
                                    return;
                                }
                            }
                        } else if (e.getButton() != 2) {
                            e.getButton();
                        }
                        SequenceDiagramCanvas.this.getModel().getSelectionModel().selectElement(element.getElement());
                        return;
                    }
                }
                SequenceDiagramCanvas.this.getModel().getSelectionModel().clearAllSelection();
            }

            public void mousePressed(MouseEvent e) {
                SequenceDiagramCanvas.this.prevMousePressPoint = e.getPoint();
            }

            public void mouseReleased(MouseEvent e) {
                if (SequenceDiagramCanvas.this.mouseDragged) {
                    SequenceDiagramCanvas.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (SequenceDiagramCanvas.this.prevMousePressPoint == null) {
                    return;
                }
                SequenceDiagramCanvas.this.mouseDragged = true;
                SequenceDiagramCanvas.this.setCursor(Cursor.getPredefinedCursor(12));
                double diffX = (double)e.getX() - SequenceDiagramCanvas.this.prevMousePressPoint.getX();
                double diffY = (double)e.getY() - SequenceDiagramCanvas.this.prevMousePressPoint.getY();
                BoundedRangeModel verticalModel = SequenceDiagramCanvas.this.verticalBar.getModel();
                BoundedRangeModel horizontalModel = SequenceDiagramCanvas.this.horizontalBar.getModel();
                double xRate = (double)horizontalModel.getMaximum() / SequenceDiagramCanvas.this.getSize().getWidth();
                double yRate = (double)verticalModel.getMaximum() / SequenceDiagramCanvas.this.getSize().getHeight();
                horizontalModel.setValue((int)((double)horizontalModel.getValue() - diffX * xRate));
                verticalModel.setValue((int)((double)verticalModel.getValue() - diffY * yRate));
            }
        });
    }

    public SequenceDiagramCanvas(SequenceModel model) {
        this.setBackground(Color.white);
        this.setModel(model);
    }

    public void setSequenceDiagramsAdjuster(SequenceDiagramsAdjuster adjuster) {
        this.adjuster = adjuster;
    }

    public SequenceModel getModel() {
        if (this.adjuster != null) {
            return this.adjuster.getModel();
        }
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        SequenceModel model = this.getModel();
        if (model == null) {
            return;
        }
        SequenceModel sequenceModel = model;
        synchronized (sequenceModel) {
            int objectNum = model.getObjectNum();
            int sequenceNum = model.getSequenceNum();
            objectsSpace = this.adjuster.getPreferredObjectsSpace();
            int x = (objectNum + 1) * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + SequenceDiagramsAdjuster.MARGIN.left + SequenceDiagramsAdjuster.MARGIN.right;
            int y = (sequenceNum + 1) * SequenceDiagramsAdjuster.SEQUENCE_SPACE + SequenceDiagramsAdjuster.MARGIN.bottom;
            Dimension newSize = new Dimension(x, y);
            this.setPreferredSize(newSize);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        SequenceModel model;
        super.paint(g);
        Iterator listIt = this.selectablePriorityList.iterator();
        while (listIt.hasNext()) {
            ((Collection)listIt.next()).clear();
        }
        if (this.adjuster != null) {
            objectsSpace = this.adjuster.getPreferredObjectsSpace();
        }
        if ((model = this.getModel()) != null) {
            SequenceModel sequenceModel = model;
            synchronized (sequenceModel) {
                Rectangle viewRange = this.getViewRange();
                int xStartIndex = ((int)viewRange.getX() - SequenceDiagramsAdjuster.MARGIN.left - SequenceDiagramsAdjuster.OBJECT_WIDTH) / (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace);
                int xEndIndex = ((int)viewRange.getX() + (int)viewRange.getWidth() - SequenceDiagramsAdjuster.MARGIN.left) / (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) - 1;
                int yStartIndex = (int)viewRange.getY() / SequenceDiagramsAdjuster.SEQUENCE_SPACE - 1;
                int yEndIndex = (int)viewRange.getHeight() / SequenceDiagramsAdjuster.SEQUENCE_SPACE + yStartIndex;
                if (xStartIndex < 0) {
                    xStartIndex = 0;
                }
                if (xEndIndex > model.getObjectList().size() - 1) {
                    xEndIndex = model.getObjectList().size() - 1;
                }
                if (yStartIndex < 0) {
                    yStartIndex = 0;
                }
                if (yEndIndex > model.getSequenceList().size() - 1) {
                    yEndIndex = model.getSequenceList().size() - 1;
                }
                this.drawBlock(g, xStartIndex, xEndIndex, yStartIndex, yEndIndex);
                this.drawLoop(g, xStartIndex, xEndIndex, yStartIndex, yEndIndex);
                this.drawObjectLine(g, xStartIndex, xEndIndex, yStartIndex, yEndIndex);
                this.drawSequence(g, xStartIndex, xEndIndex, yStartIndex, yEndIndex);
            }
        }
    }

    private void drawObjectLine(Graphics g, int xStart, int xEnd, int yStart, int yEnd) {
        yEnd += 2;
        int fontHeight = g.getFontMetrics().getHeight();
        int leftX = SequenceDiagramsAdjuster.MARGIN.left + xStart * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace);
        int lineBottom = (this.getModel().getSequenceNum() + 1) * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
        int i = xStart;
        while (i <= xEnd) {
            SequenceObject object = this.getModel().getObject(i);
            leftX += SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace;
            int madeIndex = object.getMadeIndex();
            int lastUsedIndex = object.getLastUsedIndex();
            if (yStart < madeIndex) {
                if (yEnd < madeIndex) {
                    this.drawDottedLine(g, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, yStart, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * yEnd, 5, 10);
                } else {
                    this.drawDottedLine(g, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, yStart, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * madeIndex, 5, 10);
                }
            }
            if (yStart < lastUsedIndex && yEnd > madeIndex) {
                if (yStart < madeIndex && yEnd < lastUsedIndex) {
                    g.drawLine(leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * madeIndex, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * yEnd);
                } else if (yStart < madeIndex && yEnd >= lastUsedIndex) {
                    g.drawLine(leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * madeIndex, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * lastUsedIndex);
                } else if (yStart >= madeIndex && yEnd < lastUsedIndex) {
                    g.drawLine(leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * yStart, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * yEnd);
                } else {
                    g.drawLine(leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * yStart, leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2, SequenceDiagramsAdjuster.SEQUENCE_SPACE * lastUsedIndex);
                }
            }
            Set selectedCalled = this.getModel().getSelectionModel().getSelectedCalled();
            int centerX = leftX + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2;
            int j = object.getCalledNum() - 1;
            while (j >= 0) {
                Called called = object.getCalled(j);
                if (called.getStart() <= yEnd && called.getEnd() >= yStart) {
                    int x = centerX + SequenceDiagramsAdjuster.CALLED_SIZE * called.getLevel();
                    int y = called.getStart() * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
                    int width = SequenceDiagramsAdjuster.CALLED_SIZE;
                    int height = (called.getEnd() - called.getStart() + 1) * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
                    Color backupColor = g.getColor();
                    if (this.calledIsSelected(called)) {
                        g.setColor(Color.BLUE);
                    }
                    if (called.getCallSequence().getNode().isBehind()) {
                        g.fillRect(x, y, width, height);
                    } else {
                        g.drawRect(x, y, width, height);
                    }
                    if (this.calledIsSelected(called)) {
                        g.setColor(backupColor);
                    }
                    SelectableElement sElement = new SelectableElement(new Rectangle(x, y, width, height), called, 2);
                    this.addSelectableElement(sElement);
                }
                --j;
            }
            ++i;
        }
    }

    private void drawBlock(Graphics g, int xStart, int xEnd, int yStart, int yEnd) {
        int i = this.getModel().getBlockNum() - 1;
        while (i >= 0) {
            SequenceBlock block = this.getModel().getBlock(i);
            int start = block.getStartIndex();
            int end = block.getEndIndex();
            if (end >= yStart && start <= yEnd) {
                int xMin = 0;
                int xMax = 0;
                if (block.getSequenceList().size() > 0) {
                    Sequence sequence;
                    Iterator it2 = block.getSequenceList().iterator();
                    if (it2.hasNext()) {
                        sequence = (Sequence)it2.next();
                        xMax = sequence.getEndIndex();
                        xMin = sequence.getStartIndex();
                    }
                    while (it2.hasNext()) {
                        int tmpStart;
                        sequence = (Sequence)it2.next();
                        if (sequence.getType() == 2 || !it2.hasNext()) continue;
                        int tmpEnd = sequence.getEndIndex();
                        if (sequence.getType() == 3) {
                            tmpEnd = sequence.getStartIndex() + 1;
                        }
                        if (tmpEnd < (tmpStart = sequence.getStartIndex())) {
                            int tmp = tmpEnd;
                            tmpEnd = tmpStart;
                            tmpStart = tmp;
                        }
                        if (tmpStart < xMin) {
                            xMin = tmpStart;
                        }
                        if (tmpEnd <= xMax) continue;
                        xMax = tmpEnd;
                    }
                } else {
                    xMin = block.getParentObjectIndex();
                    xMax = block.getParentObjectIndex();
                }
                if (xMin <= xEnd && xMax >= xStart) {
                    float rate = (float)block.getblockDepth() / (float)this.getModel().getMaxBlockDepth() / 2.0f;
                    int x = SequenceDiagramsAdjuster.MARGIN.left + xMin * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + (int)((float)objectsSpace * rate);
                    int y = (int)(((double)start + 0.5) * (double)SequenceDiagramsAdjuster.SEQUENCE_SPACE);
                    int width = (xMax - xMin + 1) * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) - objectsSpace - (int)((float)objectsSpace * rate * 2.0f);
                    int height = (end - start + 1) * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
                    Color backupColor = g.getColor();
                    if (this.getModel().getSelectionModel().getSeletectedBlock().contains(block)) {
                        g.setColor(selectionColor);
                        g.fillRect(x, y, width, height);
                    } else {
                        g.setColor(new Color(255, 255, 230));
                        g.fillRect(x, y, width, height);
                    }
                    g.setColor(Color.BLACK);
                    g.drawRect(x, y, width, height);
                    g.setColor(backupColor);
                    SelectableElement element = new SelectableElement(new Rectangle(x, y, width, height), block, 4);
                    ((Collection)this.selectablePriorityList.get(element.getPriority())).add(element);
                    if (block.getSequenceList().size() > 0) {
                        int tagWidth = width / 2 < BLOCK_TAG_WIDTH ? (int)((double)width * 0.5) : BLOCK_TAG_WIDTH;
                        int tagHeight = g.getFontMetrics().getHeight();
                        g.drawRect(x + width - tagWidth, y, tagWidth, tagHeight);
                        g.drawString(block.getTag(), x + width - tagWidth + 5, y + tagHeight - 2);
                    } else {
                        String blockName = block.getTag();
                        g.drawString(blockName, x + (width - g.getFontMetrics().stringWidth(blockName)) / 2, y + height / 2 + 3);
                    }
                }
            }
            --i;
        }
    }

    private void drawSequence(Graphics g, int xStart, int xEnd, int yStart, int yEnd) {
        int y = SequenceDiagramsAdjuster.SEQUENCE_SPACE * yStart;
        int half = SequenceDiagramsAdjuster.OBJECT_WIDTH / 2;
        int backStep = -5;
        int charHeight = g.getFontMetrics().getHeight();
        int i = yStart;
        while (i <= yEnd) {
            Sequence sequence = this.getModel().getSequence(i);
            y += SequenceDiagramsAdjuster.SEQUENCE_SPACE;
            if (sequence.getType() == 0) {
                boolean isSelected = this.sequenceIsSelected(i);
                Color backupColor = g.getColor();
                if (isSelected) {
                    g.setColor(Color.BLUE);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(String.valueOf(sequence.getNode().getCallIndex()) + ": " + sequence.getNode().getMethodName() + "(");
                String[] args = sequence.getNode().getArgs();
                if (args != null) {
                    int j = 0;
                    while (j < args.length) {
                        buffer.append(String.valueOf(args[j]) + ",");
                        ++j;
                    }
                    if (j > 0) {
                        buffer.deleteCharAt(buffer.length() - 1);
                    }
                }
                buffer.append(")");
                if (sequence.isBranch()) {
                    buffer.insert(0, BRANCH_MARK);
                }
                String text = buffer.toString();
                int textWidth = g.getFontMetrics().stringWidth(text);
                if (sequence.getStart() != sequence.getEnd()) {
                    SelectableElement sElement;
                    SelectableElement lineElement;
                    int x2;
                    int x1 = SequenceDiagramsAdjuster.MARGIN.left + sequence.getStartIndex() * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + half;
                    if (x1 > (x2 = SequenceDiagramsAdjuster.MARGIN.left + sequence.getEndIndex() * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + half)) {
                        g.drawLine(x1 += sequence.getStartLevel() * SequenceDiagramsAdjuster.CALLED_SIZE, y, x2 += (sequence.getEndLevel() + 1) * SequenceDiagramsAdjuster.CALLED_SIZE, y);
                        g.fillPolygon(new int[]{x2, x2 - backStep, x2 - backStep, x2}, new int[]{y, y + 5, y - 5, y}, 3);
                        g.drawString(text, x2 + 10, y - 5);
                        lineElement = new SelectableElement(new Rectangle(x1, y - 5, x2 - x1, 10), sequence, 1);
                        ((Collection)this.selectablePriorityList.get(lineElement.getPriority())).add(lineElement);
                        sElement = new SelectableElement(new Rectangle(x2 + 10, y - 5 - charHeight, textWidth, charHeight), sequence, 1);
                        ((Collection)this.selectablePriorityList.get(sElement.getPriority())).add(sElement);
                    } else {
                        g.drawLine(x1 += sequence.getStartLevel() * SequenceDiagramsAdjuster.CALLED_SIZE, y, x2 += sequence.getEndLevel() * SequenceDiagramsAdjuster.CALLED_SIZE, y);
                        g.fillPolygon(new int[]{x2, x2 + backStep, x2 + backStep, x2}, new int[]{y, y + 5, y - 5, y}, 3);
                        g.drawString(text, x2 - 10 - g.getFontMetrics().stringWidth(text), y - 5);
                        lineElement = new SelectableElement(new Rectangle(x1, y - 5, x2 - x1, 10), sequence, 1);
                        ((Collection)this.selectablePriorityList.get(lineElement.getPriority())).add(lineElement);
                        sElement = new SelectableElement(new Rectangle(x2 - 10 - textWidth, y - 5 - charHeight, textWidth, charHeight), sequence, 1);
                        ((Collection)this.selectablePriorityList.get(sElement.getPriority())).add(sElement);
                    }
                    if (sequence.isBranch()) {
                        int pareIndex = sequence.getPareSequence().getIndex();
                        int branchSpace = (pareIndex - i) * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
                        int threeDivisionSpace = branchSpace / 3;
                        int rightSpace = 30;
                        g.drawLine(x1, y, x1 + rightSpace, y + threeDivisionSpace);
                        g.drawLine(x1 + rightSpace, y + threeDivisionSpace, x1 + rightSpace, y + threeDivisionSpace * 2);
                        g.drawLine(x1 + rightSpace, y + threeDivisionSpace * 2, x1, y + branchSpace);
                        g.fillPolygon(new int[]{x1, x1 - backStep / 2, x1 - backStep, x1}, new int[]{y + branchSpace, y + branchSpace - 5, y + branchSpace, y}, 3);
                    }
                } else {
                    int x = SequenceDiagramsAdjuster.MARGIN.left + sequence.getStartIndex() * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + half;
                    g.drawLine(x += sequence.getStartLevel() * SequenceDiagramsAdjuster.CALLED_SIZE, y - SequenceDiagramsAdjuster.SEQUENCE_SPACE / 3, x + 3 * SequenceDiagramsAdjuster.CALLED_SIZE, y - SequenceDiagramsAdjuster.SEQUENCE_SPACE / 3);
                    g.drawLine(x + 3 * SequenceDiagramsAdjuster.CALLED_SIZE, y - SequenceDiagramsAdjuster.SEQUENCE_SPACE / 3, x + 3 * SequenceDiagramsAdjuster.CALLED_SIZE, y + 5);
                    g.drawLine(x + 3 * SequenceDiagramsAdjuster.CALLED_SIZE, y + 5, x + SequenceDiagramsAdjuster.CALLED_SIZE, y + 5);
                    g.drawLine(x + SequenceDiagramsAdjuster.CALLED_SIZE - backStep, y + 5 + 5, x + SequenceDiagramsAdjuster.CALLED_SIZE, y + 5);
                    g.drawLine(x + SequenceDiagramsAdjuster.CALLED_SIZE - backStep, y - 5 + 5, x + SequenceDiagramsAdjuster.CALLED_SIZE, y + 5);
                    g.drawString(text, x + 10, y - SequenceDiagramsAdjuster.SEQUENCE_SPACE / 3 - 5);
                    SelectableElement lineElement = new SelectableElement(new Rectangle(x, y - SequenceDiagramsAdjuster.SEQUENCE_SPACE / 3, 3 * SequenceDiagramsAdjuster.CALLED_SIZE, SequenceDiagramsAdjuster.SEQUENCE_SPACE / 3 + 5), sequence, 1);
                    ((Collection)this.selectablePriorityList.get(lineElement.getPriority())).add(lineElement);
                    SelectableElement sElement = new SelectableElement(new Rectangle(x + 10, y - SequenceDiagramsAdjuster.SEQUENCE_SPACE / 3 - 5 - charHeight, textWidth, charHeight), sequence, 1);
                    ((Collection)this.selectablePriorityList.get(sElement.getPriority())).add(sElement);
                }
                if (isSelected) {
                    g.setColor(backupColor);
                }
            } else if (sequence.getType() == 1) {
                boolean isSelectedPare = this.sequenceIsSelected(sequence.getPareSequence().getIndex());
                if (sequence.getStart() != sequence.getEnd()) {
                    int x2;
                    int x1;
                    Color backupColor = g.getColor();
                    if (isSelectedPare) {
                        g.setColor(Color.BLUE);
                    }
                    if ((x1 = SequenceDiagramsAdjuster.MARGIN.left + sequence.getStartIndex() * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + half) > (x2 = SequenceDiagramsAdjuster.MARGIN.left + sequence.getEndIndex() * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + half)) {
                        this.drawDottedLine(g, x1 += (sequence.getStartLevel() - 1) * SequenceDiagramsAdjuster.CALLED_SIZE, y, x2 += sequence.getEndLevel() * SequenceDiagramsAdjuster.CALLED_SIZE, y);
                        g.drawLine(x2 - backStep, y + 5, x2, y);
                        g.drawLine(x2 - backStep, y - 5, x2, y);
                        g.drawString(sequence.getNode().getReturnType(), x2 + 10, y - 5);
                    } else {
                        this.drawDottedLine(g, x1 += sequence.getStartLevel() * SequenceDiagramsAdjuster.CALLED_SIZE, y, x2 += sequence.getEndLevel() * SequenceDiagramsAdjuster.CALLED_SIZE, y);
                        g.drawLine(x2 + backStep, y + 5, x2, y);
                        g.drawLine(x2 + backStep, y - 5, x2, y);
                        g.drawString(sequence.getNode().getReturnType(), x2 - 10 - g.getFontMetrics().stringWidth(sequence.getNode().getReturnType()), y - 5);
                    }
                    if (isSelectedPare) {
                        g.setColor(backupColor);
                    }
                }
            } else if (sequence.getType() == 3) {
                int x = SequenceDiagramsAdjuster.MARGIN.left + sequence.getStartIndex() * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + half + sequence.getStartLevel() * SequenceDiagramsAdjuster.CALLED_SIZE;
                int interval = SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace;
                g.drawLine(x, y, x + interval / 4, y);
                g.fillPolygon(new int[]{x + interval / 4, x + interval / 4 + backStep, x + interval / 4 + backStep, x}, new int[]{y, y + 5, y - 5, y}, 3);
                g.drawRect(x + interval / 4, y - SequenceDiagramsAdjuster.SEQUENCE_SPACE / 10, interval / 2, (int)((double)SequenceDiagramsAdjuster.SEQUENCE_SPACE * 1.2));
                String text = sequence.getNode().getMethodName();
                int stringWidth = g.getFontMetrics().stringWidth(text);
                g.drawString(text, x + interval / 4 + interval / 4 - stringWidth / 2, y + SequenceDiagramsAdjuster.SEQUENCE_SPACE / 2 + g.getFontMetrics().getHeight() / 2);
            } else if (sequence.getType() == 4) {
                int interval = SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace;
                int x = SequenceDiagramsAdjuster.MARGIN.left + sequence.getStartIndex() * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + half + sequence.getEndLevel() * SequenceDiagramsAdjuster.CALLED_SIZE;
                g.drawLine(x, y, x + interval / 4, y);
                g.drawLine(x, y, x - backStep, y + backStep);
                g.drawLine(x, y, x - backStep, y - backStep);
            }
            ++i;
        }
    }

    private void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
        this.drawDottedLine(g, x1, y1, x2, y2, 5, 10);
    }

    private void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2, int length, int space) {
        int spaceYStep;
        int spaceXStep;
        int drawYStep;
        int drawXStep;
        int moveX = 0;
        int moveY = 0;
        int lengthX = Math.abs(x2 - x1);
        int lengthY = Math.abs(y2 - y1);
        if (lengthX != 0) {
            double rate = (double)lengthY / (double)lengthX;
            drawXStep = (int)((double)length / Math.sqrt(1.0 + rate * rate));
            drawYStep = (int)(rate * (double)drawXStep);
            spaceXStep = (int)((double)space / Math.sqrt(1.0 + rate * rate));
            spaceYStep = (int)(rate * (double)spaceXStep);
        } else {
            drawXStep = 0;
            drawYStep = length;
            spaceXStep = 0;
            spaceYStep = space;
        }
        if (x2 < x1) {
            drawXStep = -drawXStep;
            spaceXStep = -spaceXStep;
        }
        if (y2 < y1) {
            drawYStep = -drawYStep;
            spaceYStep = -spaceYStep;
        }
        int positionX = x1;
        int positionY = y1;
        while (moveX < lengthX || moveY < lengthY) {
            g.drawLine(positionX, positionY, positionX + drawXStep, positionY + drawYStep);
            positionX += drawXStep + spaceXStep;
            positionY += drawYStep + spaceYStep;
            moveX += Math.abs(drawXStep + spaceXStep);
            moveY += Math.abs(drawYStep + spaceYStep);
        }
    }

    private void drawLoop(Graphics g, int xStart, int xEnd, int yStart, int yEnd) {
        int gap = SequenceDiagramsAdjuster.SEQUENCE_SPACE / 2 - 5;
        int fontHeight = g.getFontMetrics().getHeight();
        int maxLoopDepth = this.getModel().getMaxLoopDepth();
        int i = this.getModel().getLoopNum() - 1;
        while (i >= 0) {
            SequenceObject object;
            int oIndex;
            SequenceLoop loop = this.model.getLoop(i);
            if (loop.getStart() <= yEnd && loop.getEnd() >= yStart && (oIndex = (object = loop.getParentObject()) == null ? 0 : object.getIndex()) >= xStart && oIndex <= xEnd) {
                int x1 = SequenceDiagramsAdjuster.MARGIN.left + oIndex * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) - objectsSpace / 2;
                int x2 = SequenceDiagramsAdjuster.MARGIN.left + oIndex * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace) + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2;
                x1 += loop.getDepth() * (x2 - x1) / (maxLoopDepth + 1);
                int y1 = (loop.getStart() + 1) * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
                int y2 = (loop.getEnd() + 1) * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
                LoopNode loopNode = loop.getNode();
                Color backupColor = g.getColor();
                if (this.getModel().getSelectionModel().getSelectedLoops().contains(loop)) {
                    g.setColor(selectionColor);
                    g.fillRect(x1, y1 - gap, x2 - x1, y2 - y1 + gap * 2);
                }
                if (loopNode instanceof SimpleLoopNode) {
                    g.setColor(Color.BLACK);
                } else if (loopNode instanceof ObjectDifferenceLoopNode) {
                    g.setColor(Color.BLUE);
                } else if (loopNode instanceof MethodMissingLoopNode) {
                    g.setColor(Color.RED);
                }
                g.drawLine(x1, y1 - gap, x2, y1 - gap);
                g.drawLine(x1, y1 - gap, x1, y2 + gap);
                g.drawLine(x1, y2 + gap, x2, y2 + gap);
                int stringX = x1 + 5;
                int stringY = (y2 + y1 + fontHeight) / 2;
                int stringIndex = (loop.getStart() + loop.getEnd()) / 2;
                if (!loopNode.isFold()) {
                    g.drawString("1", stringX, stringY);
                } else if (loopNode.getLoopNums().size() > 1) {
                    g.drawString(loopNode.getLoopNum(0) + "-" + loopNode.getLoopNum(loopNode.getLoopNums().size() - 1), stringX, stringY);
                } else {
                    g.drawString("" + loopNode.getLoopNum(0), stringX, stringY);
                }
                SelectableElement element = new SelectableElement(new Rectangle(x1, y1 - gap, x2 - x1, y2 - y1 + gap * 2), loop, 3);
                ((Collection)this.selectablePriorityList.get(element.getPriority())).add(element);
                g.setColor(backupColor);
            }
            --i;
        }
    }

    private boolean sequenceIsSelected(int index) {
        Set selectedIndexes = this.getModel().getSelectionModel().getSelectedSequenceIndex();
        Iterator it = selectedIndexes.iterator();
        while (it.hasNext()) {
            int selectedIndex = (Integer)it.next();
            int pareIndex = this.getModel().getSequence(selectedIndex).getPareSequence().getIndex();
            if (index < selectedIndex || index > pareIndex) continue;
            return true;
        }
        Set calles = this.getModel().getSelectionModel().getSelectedCalled();
        Iterator it2 = calles.iterator();
        while (it2.hasNext()) {
            Called called = (Called)it2.next();
            if (called.getStart() > index || called.getEnd() < index) continue;
            return true;
        }
        Set objects = this.getModel().getSelectionModel().getSelectedObjectIndex();
        Iterator it3 = objects.iterator();
        while (it3.hasNext()) {
            SequenceObject object = this.getModel().getObject((Integer)it3.next());
            Sequence sequence = this.getModel().getSequence(index);
            if (sequence.getStart() != object && sequence.getEnd() != object) continue;
            return true;
        }
        Set loops = this.getModel().getSelectionModel().getSelectedLoops();
        Iterator it4 = loops.iterator();
        while (it4.hasNext()) {
            SequenceLoop loop = (SequenceLoop)it4.next();
            if (loop.getStart() > index || loop.getEnd() < index) continue;
            return true;
        }
        return false;
    }

    private boolean calledIsSelected(Called called) {
        if (this.getModel().getSelectionModel().getSelectedCalled().contains(called)) {
            return true;
        }
        if (this.getModel().getSelectionModel().getSelectedObjectIndex().contains(new Integer(called.getObject().getIndex() - 1))) {
            return true;
        }
        return this.sequenceIsSelected(called.getCallSequence().getIndex());
    }

    protected Rectangle getViewRange() {
        if (this.verticalBar == null) {
            Container comp = this;
            while ((comp = comp.getParent()) != null && !(comp instanceof JScrollPane)) {
            }
            if (comp != null) {
                this.verticalBar = ((JScrollPane)comp).getVerticalScrollBar();
                this.horizontalBar = ((JScrollPane)comp).getHorizontalScrollBar();
            }
        }
        Dimension size = this.getSize();
        if (this.verticalBar == null) {
            return new Rectangle(0, 0, (int)size.getWidth(), (int)size.getHeight());
        }
        BoundedRangeModel model = this.horizontalBar.getModel();
        int x = (int)((double)size.width * ((double)model.getValue() / (double)model.getMaximum()));
        int width = (int)((double)size.width * ((double)model.getExtent() / (double)model.getMaximum()));
        model = this.verticalBar.getModel();
        int y = (int)((double)size.height * ((double)model.getValue() / (double)model.getMaximum()));
        int height = (int)((double)size.height * ((double)model.getExtent() / (double)model.getMaximum()));
        return new Rectangle(x, y, width, height);
    }

    public void scroll(int objectNum, int sequenceNum) {
        int scrollY;
        int scrollX;
        BoundedRangeModel verticalModel = this.verticalBar.getModel();
        BoundedRangeModel horizontalModel = this.horizontalBar.getModel();
        Dimension size = this.getSize();
        if (objectNum >= 0 && objectNum < this.getModel().getObjectNum()) {
            int pointX = SequenceDiagramsAdjuster.MARGIN.left + SequenceDiagramsAdjuster.OBJECT_WIDTH / 2 + objectNum * (SequenceDiagramsAdjuster.OBJECT_WIDTH + objectsSpace);
            scrollX = (int)((double)pointX / size.getWidth() * (double)horizontalModel.getMaximum() - (double)(horizontalModel.getExtent() / 2));
        } else {
            scrollX = horizontalModel.getValue();
        }
        if (sequenceNum >= 0 && sequenceNum < this.getModel().getSequenceNum()) {
            int pointY = sequenceNum * SequenceDiagramsAdjuster.SEQUENCE_SPACE;
            scrollY = (int)((double)pointY / size.getHeight() * (double)verticalModel.getMaximum() - (double)(verticalModel.getExtent() / 2));
        } else {
            scrollY = verticalModel.getValue();
        }
        horizontalModel.setValue(scrollX);
        verticalModel.setValue(scrollY);
    }

    public void dataChanged() {
        this.resize();
        this.repaint();
    }

    protected void setModel(SequenceModel model) {
        this.model = model;
        model.addDataChangeListener(this);
        model.getSelectionModel().addSelectionListener(this);
        this.resize();
    }

    public void selectionChanged() {
        this.repaint();
    }

    public void addSelectableElement(SelectableElement e) {
        ((Collection)this.selectablePriorityList.get(e.getPriority())).add(e);
    }
}

