/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencer.gui;

import amida.node.CallTree;
import amida.node.CallTreeManager;
import amida.sequencer.SequenceModel;
import amida.sequencer.gui.SequenceDiagramPanel;
import amida.sequencer.gui.SequenceDiagramsAdjuster;
import amida.sequencer.gui.SequenceMapCanvas;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class SequenceDiagramTabbedPane
extends JTabbedPane {
    private static SequenceDiagramTabbedPane singleton = new SequenceDiagramTabbedPane();
    private final JPopupMenu popupMenu = new JPopupMenu();
    private boolean isDefault = false;
    private SequenceDiagramPanel defaultDiagram;

    private SequenceDiagramTabbedPane() {
        JMenuItem closeMenuItem = new JMenuItem("close");
        this.popupMenu.add(closeMenuItem);
        closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = SequenceDiagramTabbedPane.this.getSelectedIndex();
                SequenceDiagramTabbedPane.this.remove(index);
                SequenceDiagramTabbedPane.this.fireStateChanged();
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SequenceDiagramsAdjuster oldAdjuster = SequenceMapCanvas.getInstance().getAdjuster();
                SequenceDiagramPanel selected = SequenceDiagramTabbedPane.this.getSelectedDiagram();
                if (selected != null) {
                    if (oldAdjuster != selected.getAdjuster()) {
                        if (oldAdjuster != null) {
                            oldAdjuster.removeMapCanvas();
                        }
                        selected.getAdjuster().setMapCanvas(SequenceMapCanvas.getInstance());
                        SequenceMapCanvas.getInstance().resize();
                        SequenceMapCanvas.getInstance().autoScroll();
                    }
                } else {
                    if (oldAdjuster != null) {
                        oldAdjuster.removeMapCanvas();
                    }
                    SequenceMapCanvas.getInstance().setModel(null);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index = SequenceDiagramTabbedPane.this.indexAtLocation(e.getX(), e.getY());
                if (index >= 0 && index < SequenceDiagramTabbedPane.this.getTabCount() && e.getButton() != 2) {
                    if (e.isPopupTrigger()) {
                        SequenceDiagramTabbedPane.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getButton() == 3) {
                        SequenceDiagramTabbedPane.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    public static SequenceDiagramTabbedPane getInstance() {
        return singleton;
    }

    public void addNewDiagram(SequenceDiagramPanel diagram) {
        this.addTab(diagram.getDiagramName(), diagram);
        this.setSelectedComponent(diagram);
        if (this.isDefault) {
            this.remove(this.defaultDiagram);
            this.isDefault = false;
        }
    }

    public void addNewDiagram(SequenceModel model, String name) {
        SequenceDiagramPanel diagram = new SequenceDiagramPanel(model, this.makeTitle(name));
        this.addTab(diagram.getDiagramName(), diagram);
        this.setSelectedComponent(diagram);
        if (this.isDefault) {
            this.remove(this.defaultDiagram);
            this.isDefault = false;
        }
    }

    public void insertNewDiagram(SequenceDiagramPanel diagram, int index) {
        this.insertTab(diagram.getDiagramName(), null, diagram, null, index);
        this.setSelectedComponent(diagram);
    }

    public SequenceDiagramPanel getDiagram(int index) {
        if (index >= 0 && index < this.getTabCount()) {
            return (SequenceDiagramPanel)this.getComponent(index);
        }
        return null;
    }

    public SequenceDiagramPanel getDiagram(String title) {
        return this.getDiagram(this.indexOfTab(title));
    }

    public SequenceDiagramPanel getSelectedDiagram() {
        return (SequenceDiagramPanel)this.getSelectedComponent();
    }

    private String makeTitle(String name) {
        String candidate = name;
        int i = 2;
        while (this.isAlreadyUsed(candidate)) {
            candidate = String.valueOf(name) + "(" + i + ")";
            ++i;
        }
        return candidate;
    }

    private boolean isAlreadyUsed(String name) {
        int i = this.getTabCount() - 1;
        while (i >= 0) {
            if (name.equals(this.getTitleAt(i))) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected void clearUnreferencedCallTree() {
        int callTreeNum = CallTreeManager.getInstance().getCallTreeNum();
        int i = 0;
        while (i < callTreeNum) {
            boolean isUsed = false;
            CallTree tree = CallTreeManager.getInstance().getCallTree(i);
            Component[] components = this.getComponents();
            int j = 0;
            while (j < components.length) {
                if (tree == ((SequenceDiagramPanel)components[j]).getModel().getCallTree()) {
                    isUsed = true;
                    break;
                }
                ++j;
            }
            if (!isUsed) {
                CallTreeManager.getInstance().removeCallTree(tree);
            }
            ++i;
        }
    }

    public void remove(Component arg0) {
        super.remove(arg0);
        this.clearUnreferencedCallTree();
    }

    public void remove(int arg0) {
        super.remove(arg0);
        this.clearUnreferencedCallTree();
    }

    public void removeAll() {
        super.removeAll();
        this.clearUnreferencedCallTree();
    }

    public void removeTabAt(int arg0) {
        super.removeTabAt(arg0);
        this.clearUnreferencedCallTree();
    }

    private class MyTabbedPaneUI
    extends BasicTabbedPaneUI {
        MyTabbedPaneUI() {
        }

        protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
            if (tabIndex >= SequenceDiagramTabbedPane.this.getTabCount()) {
                tabIndex = SequenceDiagramTabbedPane.this.getTabCount() - 1;
            }
            return super.getTabBounds(tabIndex, dest);
        }
    }
}

