/*
 * Decompiled with CFR 0.152.
 */
package amida.logdecoder;

public class MethodSignature {
    private static final String DELIM = "[(){,\\s]";
    private String packageName;
    private String className;
    private String methodName;
    private String returnType;
    private String[] args;

    public MethodSignature(String method_sig) {
        this.parse(method_sig);
    }

    private void parse(String method_sig) {
        String[] s = method_sig.split(DELIM);
        this.returnType = s[0].intern();
        int idx = s[1].lastIndexOf(".");
        String[] sig = MethodSignature.splitClassSig(s[1].substring(0, idx));
        this.methodName = s[1].substring(idx + 1).intern();
        this.packageName = sig[0].intern();
        this.className = sig[1].intern();
        this.args = new String[s.length - 2];
        int i = 2;
        while (i < s.length) {
            this.args[i - 2] = s[i].intern();
            ++i;
        }
    }

    public static String[] splitClassSig(String class_sig) {
        String[] s = new String[2];
        int idx = class_sig.lastIndexOf(".");
        s[0] = class_sig.substring(0, idx).intern();
        s[1] = class_sig.substring(idx + 1).intern();
        return s;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String toDictionaryString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.returnType) + " ");
        buf.append(String.valueOf(this.packageName) + ".");
        buf.append(String.valueOf(this.className) + ".");
        buf.append(String.valueOf(this.methodName) + "(");
        int i = 0;
        while (i < this.args.length) {
            buf.append(String.valueOf(this.args[i]) + ",");
            ++i;
        }
        if (i > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        buf.append("){");
        return buf.toString();
    }
}

