/*
 * Decompiled with CFR 0.152.
 */
package amida.logloader;

import amida.LanguageType;
import amida.logloader.EntryType;
import amida.logloader.ExternalThreadInfoReader;
import amida.logloader.LogEntry;
import amida.logloader.LogFile;
import amida.logloader.LogParser;
import amida.utility.FileRangeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;

public class TextLogFile
extends LogFile {
    private final Set<Character> separatorSet = new TreeSet<Character>();
    private Reader reader;

    public TextLogFile(File logFile, LanguageType language, String separators, LogParser parser, boolean preLoad, int pbegin, int pend, File externalLogFile) {
        super(logFile, language, parser, preLoad);
        int i = 0;
        while (i < separators.length()) {
            this.separatorSet.add(Character.valueOf(separators.charAt(i)));
            ++i;
        }
        try {
            this.reader = pbegin >= 0 ? new BufferedReader(new FileRangeReader(new FileReader(logFile), pbegin, pend)) : new BufferedReader(new FileReader(logFile));
            if (externalLogFile != null) {
                this.reader = new ExternalThreadInfoReader(this.reader, externalLogFile);
            }
            if (preLoad) {
                Object o;
                int count = 0;
                while ((o = this.read()) != null) {
                    LogEntry entry;
                    Queue<LogEntry> queue = parser.parse(o);
                    while ((entry = queue.poll()) != null) {
                        if (entry.getEntryType() == EntryType.METHOD_CALL) {
                            ++count;
                        }
                        if (entry.getEntryType() == EntryType.UNKNOWN) continue;
                        this.addEntry(entry);
                    }
                }
                this.setMethodCallCount(count);
            }
        }
        catch (FileNotFoundException e) {
            this.reader = null;
        }
        catch (IOException e) {
            this.reader = null;
        }
    }

    @Override
    protected Object read() {
        StringBuffer buffer = new StringBuffer();
        try {
            int i;
            while ((i = this.reader.read()) != -1) {
                char c = (char)i;
                if (this.separatorSet.contains(Character.valueOf(c))) break;
                buffer.append(c);
            }
            if (i == -1) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    public boolean hasLogSource() {
        return this.reader != null;
    }
}

