/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java.data;

import amida.staticdata.AccessModifier;
import amida.staticdata.ClassData;
import amida.staticdata.Field;
import amida.staticdata.Type;
import amida.staticdata.java.data.JavaAccessModifier;
import amida.staticdata.java.data.JavaClassOrInterface;
import amida.staticdata.java.data.JavaType;
import java.util.HashMap;
import java.util.Map;

public class JavaField
implements Field {
    private static final Map<JavaClassOrInterface, Map<String, JavaField>> fieldMap = new HashMap<JavaClassOrInterface, Map<String, JavaField>>();
    private final String name;
    private final Type type;
    private AccessModifier accessModifier;
    private boolean isStatic;
    private final JavaClassOrInterface coi;

    public static JavaField makeField(JavaClassOrInterface coi, String name, JavaType type, JavaAccessModifier modifier, boolean isStatic) {
        if (fieldMap.containsKey(coi)) {
            Map<String, JavaField> nameMap = fieldMap.get(coi);
            if (nameMap.containsKey(name)) {
                return nameMap.get(name);
            }
            JavaField field = new JavaField(coi, name, type, modifier, isStatic);
            nameMap.put(name, field);
            return field;
        }
        HashMap<String, JavaField> nameMap = new HashMap<String, JavaField>();
        JavaField field = new JavaField(coi, name, type, modifier, isStatic);
        nameMap.put(name, field);
        fieldMap.put(coi, nameMap);
        return field;
    }

    public static JavaField getField(JavaClassOrInterface coi, String name) {
        Map<String, JavaField> nameMap;
        if (fieldMap.containsKey(coi) && (nameMap = fieldMap.get(coi)).containsKey(name)) {
            return nameMap.get(name);
        }
        return null;
    }

    public static boolean hasField(JavaClassOrInterface coi, String name) {
        if (fieldMap.containsKey(coi)) {
            return fieldMap.get(coi).containsKey(name);
        }
        return false;
    }

    private JavaField(JavaClassOrInterface coi, String name, Type type, AccessModifier access, boolean isStatic) {
        this.name = name;
        this.type = type;
        this.accessModifier = access;
        this.isStatic = isStatic;
        this.coi = coi;
        coi.addField(this);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isClassField() {
        return this.isStatic;
    }

    @Override
    public boolean isInstanceField() {
        return !this.isStatic;
    }

    @Override
    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    @Override
    public ClassData getBelongClass() {
        return this.coi;
    }

    public void setAccessModifier(AccessModifier accessModifier) {
        this.accessModifier = accessModifier;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String toString() {
        return String.valueOf(this.accessModifier.getModifierName()) + " " + this.type.toString() + " " + this.name;
    }
}

