/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.filter.ObjectIDMatcher;
import amida.viewer.filter.StringMatcher;
import java.util.Set;

public abstract class AbstractFilter {
    private String packageCondition = "";
    private String classCondition = "";
    private String objectCondition = "";
    private boolean useRegex = false;
    private StringMatcher packageMatcher = new StringMatcher("");
    private StringMatcher classMatcher = new StringMatcher("");
    private ObjectIDMatcher objectMatcher = new ObjectIDMatcher("");

    protected AbstractFilter() {
    }

    public String getPackageCondition() {
        return this.packageCondition;
    }

    public void setPackageCondition(String packageCondition) {
        this.packageCondition = packageCondition.trim();
        this.packageMatcher = new StringMatcher(packageCondition);
    }

    public String getClassCondition() {
        return this.classCondition;
    }

    public void setClassCondition(String classCondition) {
        this.classCondition = classCondition.trim();
        this.classMatcher = new StringMatcher(classCondition);
    }

    public String getObjectCondition() {
        return this.objectCondition;
    }

    public void setTypeIndex(int value) {
    }

    public int getTypeIndex() {
        return 0;
    }

    public void setObjectCondition(String objectCondition) {
        this.objectCondition = objectCondition.trim();
        this.objectMatcher = new ObjectIDMatcher(objectCondition);
    }

    public boolean getUseRegex() {
        return this.useRegex;
    }

    public void setUseRegex(boolean useRegex) {
        this.useRegex = useRegex;
    }

    protected boolean matchPackage(String packageName) {
        return this.packageCondition.length() == 0 || !this.useRegex && this.packageMatcher.match(packageName) || this.useRegex && packageName.matches(this.packageCondition);
    }

    protected boolean matchClass(String className) {
        return this.classCondition.length() == 0 || !this.useRegex && this.classMatcher.match(className) || this.useRegex && className.matches(this.classCondition);
    }

    protected boolean matchObject(Set<Integer> ids) {
        for (Integer id : ids) {
            if (!this.objectMatcher.match(id)) continue;
            return true;
        }
        return false;
    }

    protected void copyAttributesTo(AbstractFilter clone) {
        clone.setTypeIndex(this.getTypeIndex());
        clone.setPackageCondition(this.getPackageCondition());
        clone.setClassCondition(this.getClassCondition());
        clone.setObjectCondition(this.getObjectCondition());
        clone.setUseRegex(this.getUseRegex());
    }
}

