/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class StringMatcher {
    private String[] patterns;
    private boolean endWithWildcard;
    private Set<String> trueCache = new HashSet<String>();
    private Set<String> falseCache = new HashSet<String>();

    public StringMatcher(String pattern) {
        if (pattern.length() == 0) {
            this.patterns = new String[0];
            return;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int idx = 0;
        while (idx < pattern.length()) {
            int pos = pattern.indexOf(42, idx);
            if (pos == -1) {
                tokens.add(pattern.substring(idx));
                break;
            }
            tokens.add(pattern.substring(idx, pos));
            idx = pos + 1;
            if (idx != pattern.length()) continue;
            this.endWithWildcard = true;
        }
        this.patterns = tokens.toArray(new String[0]);
    }

    public boolean match(String target) {
        if (this.patterns.length == 0) {
            return true;
        }
        if (this.trueCache.contains(target)) {
            return true;
        }
        if (this.falseCache.contains(target)) {
            return false;
        }
        boolean ret = this.matchInternal(target);
        if (ret) {
            this.trueCache.add(target);
        } else {
            this.falseCache.add(target);
        }
        return ret;
    }

    public boolean matchInternal(String target) {
        int idx = 0;
        int endIdx = 0;
        int i = 0;
        while (i < this.patterns.length) {
            int pos = target.indexOf(this.patterns[i], idx);
            endIdx = pos + this.patterns[i].length();
            if (pos == -1) {
                return false;
            }
            if (i == 0 && this.patterns[i].length() != 0 && pos != 0) {
                return false;
            }
            idx = endIdx;
            ++i;
        }
        return endIdx == target.length() || this.endWithWildcard;
    }

    public static void main(String[] args) {
        StringMatcher matcher = new StringMatcher("java.*.Main");
        assert (matcher.match("java.hoge.Main"));
        assert (!matcher.match("java.hoge.MainStream"));
        assert (matcher.match("java.hoge.fuga.Main"));
        assert (!matcher.match("java.hoge.main"));
        assert (!matcher.match("java.hoge.test"));
        matcher = new StringMatcher("*");
        assert (matcher.match("java.hoge.main"));
        assert (matcher.match("java.hoge.test"));
        matcher = new StringMatcher("*Main");
        assert (matcher.match("java.hoge.Main"));
        assert (!matcher.match("java.hoge.MainStream"));
        matcher = new StringMatcher("java.hoge.Main*");
        assert (!matcher.match("java.hoge."));
        assert (matcher.match("java.hoge.Main"));
        assert (matcher.match("java.hoge.MainStream"));
        matcher = new StringMatcher("");
        assert (matcher.match("java.hoge.main"));
        assert (matcher.match("java.hoge.test"));
        matcher = new StringMatcher("java.*.*.Main");
        assert (matcher.match("java.hoge.fuga.Main"));
        assert (!matcher.match("java.hoge.Main"));
        matcher = new StringMatcher("java.hoge.Main");
        assert (matcher.match("java.hoge.Main"));
        matcher = new StringMatcher("java*Main");
        assert (matcher.match("java.hoge.fuga.Main"));
        assert (matcher.match("java.hoge.Main"));
    }
}

