/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret;

import gnu.trove.map.TObjectCharMap;
import gnu.trove.map.hash.TObjectCharHashMap;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class OptionContainer {
    private int diffType = 0;
    private Path diffCommand;
    private Path graphvizPath;
    private TObjectCharMap<String> types;
    private boolean onMemory;
    private boolean skip;
    private Path tmp;
    private Path result;

    public OptionContainer(String[] args) {
        CommandLine cmd;
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"diff");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"diff command");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"m");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"save similarity and/or diff on memory");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"graph");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dot command");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"type");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"tmp");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"temp directory");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"result");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"result output directory");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"thread");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"thread");
        options.addOption(OptionBuilder.create());
        BasicParser parser = new BasicParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("PARSE ARGS ERROR");
            return;
        }
        FileSystem fs = FileSystems.getDefault();
        if (cmd.hasOption("diff")) {
            this.diffType = Integer.parseInt(cmd.getOptionValues("diff")[0]);
            Path path = this.diffCommand = cmd.getOptionValues("diff").length > 0 ? fs.getPath(cmd.getOptionValues("diff")[0], new String[0]) : null;
        }
        if (cmd.hasOption("graph")) {
            this.graphvizPath = fs.getPath(cmd.getOptionValue("graph"), new String[0]);
            if (!Files.isExecutable(this.graphvizPath)) {
                this.graphvizPath = null;
            }
        }
        if (cmd.hasOption("type")) {
            this.types = new TObjectCharHashMap();
            this.readTypeConf(fs.getPath(cmd.getOptionValue("type"), new String[0]));
        }
        this.tmp = cmd.hasOption("tmp") ? fs.getPath(cmd.getOptionValue("tmp"), new String[0]) : fs.getPath(".", new String[0]);
        this.result = cmd.hasOption("result") ? fs.getPath(cmd.getOptionValue("result"), new String[0]) : this.tmp;
        ParaRun.para = cmd.hasOption("thread") ? Integer.parseInt(cmd.getOptionValue("thread")) : 1;
        if (cmd.hasOption('m')) {
            this.onMemory = true;
            if (Objects.equals(cmd.getOptionValue('m'), "skip")) {
                this.skip = true;
            }
        }
    }

    private void readTypeConf(Path path) {
        if (path == null || Files.isDirectory(path, new LinkOption[0])) {
            this.types.put((Object)"", 'D');
            return;
        }
        try {
            for (String line : Files.readAllLines(path, EncodeDetector.charset(path))) {
                String[] test = line.split(",");
                if (test.length > 1) {
                    this.types.put((Object)test[0], test[1].charAt(0));
                    continue;
                }
                this.types.put((Object)test[0], 'D');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Path diffCommand() {
        return this.diffCommand;
    }

    public Path graphvizPath() {
        return this.graphvizPath;
    }

    public Path tmp() {
        return this.tmp;
    }

    public Path result() {
        return this.result;
    }

    public TObjectCharMap<String> types() {
        return this.types;
    }

    public boolean onMemory() {
        return this.onMemory;
    }

    public boolean skip() {
        return this.skip;
    }

    public int diffType() {
        return this.diffType;
    }
}

