/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectoryInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.preprocess.Preprocessor;
import jp.ac.osaka_u.ist.sel.pret.engine.preprocess.PreprocessorFactory;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class FileInfoMaker {
    private int nextFileId;
    private int projectId;
    private Path tmp;
    private List<Maker> targets;
    private TIntObjectMap<FileInfo> newFiles;

    public FileInfoMaker(int projectId, int nextFileId, Path projectTmp) {
        this.tmp = projectTmp;
        this.projectId = projectId;
        this.nextFileId = nextFileId;
        this.newFiles = new TIntObjectHashMap();
        this.targets = new ArrayList<Maker>();
    }

    public TIntObjectMap<FileInfo> make() {
        ParaRun<Maker> pararun = new ParaRun<Maker>();
        pararun.addAll(this.targets);
        this.newFiles = new TIntObjectHashMap();
        pararun.run();
        return this.newFiles;
    }

    public void add(Path target, DirectoryInfo parent, char type) {
        this.targets.add(new Maker(target, this.nextFileId++, parent, type));
    }

    private class Maker
    implements Runnable {
        Path path;
        int fileId;
        DirectoryInfo parent;
        char type;

        public Maker(Path path, int fileId, DirectoryInfo parent, char type) {
            this.path = path;
            this.fileId = fileId;
            this.parent = parent;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileInfo fi = new FileInfo(this.fileId, FileInfoMaker.this.projectId, this.path.toUri(), this.parent, this.type);
            Preprocessor pp = PreprocessorFactory.create(this.type, FileInfoMaker.this.tmp);
            pp.preprocessForCalcSimilarity(fi);
            pp.preprocessForDiff(fi);
            TIntObjectMap tIntObjectMap = FileInfoMaker.this.newFiles;
            synchronized (tIntObjectMap) {
                FileInfoMaker.this.newFiles.put(this.fileId, (Object)fi);
            }
        }
    }
}

