/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public class SimilarityOnMemorySkipDiff
implements ISimilarity,
Serializable {
    private static final long serialVersionUID = 3004214404223078368L;
    private TObjectFloatMap<Edge> sim = new TObjectFloatHashMap();
    private TObjectIntMap<Edge> incm = new TObjectIntHashMap();
    private TObjectIntMap<Edge> decm = new TObjectIntHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSimilarity(Edge edge, float similarity) {
        TObjectFloatMap<Edge> tObjectFloatMap = this.sim;
        synchronized (tObjectFloatMap) {
            this.sim.put((Object)edge, similarity);
        }
    }

    @Override
    public float getSimilarity(Edge edge) {
        if (this.sim.containsKey((Object)edge)) {
            return this.sim.get((Object)edge);
        }
        return -2.2f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDiff(Edge edge, String diff) {
        String diffText = diff.replaceAll("\r\n", "\n").replaceAll("[^<>].*\\n", "");
        int dec = 0;
        char[] cArray = diffText.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '<') {
                ++dec;
            }
            ++n2;
        }
        int inc = diffText.length() - dec;
        TObjectIntMap<Edge> tObjectIntMap = this.incm;
        synchronized (tObjectIntMap) {
            this.incm.put((Object)edge, inc);
        }
        tObjectIntMap = this.decm;
        synchronized (tObjectIntMap) {
            this.decm.put((Object)edge, dec);
        }
    }

    @Override
    public String getDiff(Edge edge) {
        if (this.incm.containsKey((Object)edge)) {
            return "";
        }
        return null;
    }

    @Override
    public int getDiffSize(Edge edge) {
        if (this.sim.containsKey((Object)edge)) {
            return this.incm.get((Object)edge) + this.decm.get((Object)edge);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getDiffSize(int v, int u) {
        return this.getDiffSize(new Edge(v, u));
    }

    @Override
    public int getDec(Edge edge) {
        if (this.decm.containsKey((Object)edge)) {
            return this.decm.get((Object)edge);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getInc(Edge edge) {
        if (this.incm.containsKey((Object)edge)) {
            return this.incm.get((Object)edge);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Set<Edge> edges() {
        return new THashSet((Collection)this.sim.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIncDec(Edge edge, int add, int del) {
        TObjectIntMap<Edge> tObjectIntMap = this.decm;
        synchronized (tObjectIntMap) {
            this.decm.put((Object)edge, del);
        }
        tObjectIntMap = this.incm;
        synchronized (tObjectIntMap) {
            this.incm.put((Object)edge, add);
        }
    }
}

