/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.ADiff;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.DiffCommandDiff;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.DiffCygwinDiff;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.DiffTKJavaDiff;

public class CalcDiff {
    private Path diffCommand;
    private int diffType;
    private static final int LCS_J = 0;
    private static final int DIFF_J = 1;
    private static final int DIFF_COM = 5;
    private static final int DIFF_CYG = 6;

    public CalcDiff(int diffType, Path path) {
        this.diffCommand = path;
        this.diffType = diffType;
        if (diffType >= 5) {
            if (this.diffCommand != null && Files.isExecutable(this.diffCommand)) {
                this.diffCommand = path;
            } else {
                this.diffType = 0;
            }
        }
    }

    public void calcAll(ISimilarity similarity, Collection<FileInfo> files, float threshold) {
        switch (this.diffType) {
            case 5: {
                ADiff aDiff = new DiffCommandDiff(similarity, this.diffCommand.toString(), threshold);
            }
            case 6: {
                ADiff aDiff = new DiffCygwinDiff(similarity, this.diffCommand.toString(), threshold);
            }
        }
        DiffTKJavaDiff diff = new DiffTKJavaDiff(similarity, threshold);
        ((ADiff)diff).calcAll(files);
    }
}

