/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.ADiff;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.TKJavaDiff;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class DiffTKJavaDiff
extends ADiff {
    public DiffTKJavaDiff(ISimilarity similarity, float threshold) {
        super(similarity, threshold);
    }

    @Override
    public void calcAll(Collection<FileInfo> files) {
        ParaRun<Calc> para = new ParaRun<Calc>();
        for (FileInfo fi : files) {
            para.add(new Calc(fi, files));
        }
        para.run2();
    }

    private class Calc
    implements Runnable {
        private FileInfo target;
        private Collection<FileInfo> others;

        public Calc(FileInfo target, Collection<FileInfo> others) {
            this.target = target;
            this.others = others;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TKJavaDiff diff = new TKJavaDiff();
            Path file1 = Paths.get(this.target.preSim);
            char file1type = this.target.type();
            List<String> sA = TKJavaDiff.listLines(file1);
            int f1id = this.target.fileId();
            for (FileInfo other : this.others) {
                List<String> s2;
                List<String> s1;
                Path f2;
                Path f1;
                int f2id = other.fileId();
                if (f1id <= f2id || file1type != other.type()) continue;
                Path file2 = Paths.get(other.preSim);
                Edge edge = new Edge(this.target.fileId(), other.fileId());
                if (!(DiffTKJavaDiff.this.similarity.getSimilarity(edge) >= DiffTKJavaDiff.this.threshold) || DiffTKJavaDiff.this.similarity.getDiff(edge) != null) continue;
                if (this.target.fileId() < other.fileId()) {
                    f1 = file1;
                    f2 = file2;
                    s1 = sA;
                    s2 = TKJavaDiff.listLines(file2);
                } else {
                    f1 = file2;
                    f2 = file1;
                    s1 = TKJavaDiff.listLines(file2);
                    s2 = sA;
                }
                String d = diff.diff(f1, s1, f2, s2);
                ISimilarity iSimilarity = DiffTKJavaDiff.this.similarity;
                synchronized (iSimilarity) {
                    DiffTKJavaDiff.this.similarity.setDiff(edge, d);
                }
            }
        }
    }
}

