/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.ADiffCmd;
import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;
import jp.ac.osaka_u.ist.sel.t_kanda.tkdiff.Diff;
import jp.ac.osaka_u.ist.sel.t_kanda.tkdiff.Difference;

public class TKJavaDiff
extends ADiffCmd {
    private List<String> sA;
    private List<String> sB;

    @Override
    public void set(Path file1, Path file2) {
        this.sA = TKJavaDiff.listLines(file1);
        this.sB = TKJavaDiff.listLines(file2);
        this.calc();
    }

    public void set(List<String> sA, Path file2) {
        this.sA = sA;
        this.sB = TKJavaDiff.listLines(file2);
        this.calc();
    }

    @Override
    protected void calc() {
        Diff diff = new Diff(this.sA, this.sB);
        List<Difference> diffList = diff.diff();
        int nAdd = 0;
        int nDel = 0;
        for (Difference d : diffList) {
            if (d.getDeletedEnd() >= 0) {
                nDel += d.getDeletedEnd() - d.getDeletedStart() + 1;
            }
            if (d.getAddedEnd() < 0) continue;
            nAdd += d.getAddedEnd() - d.getAddedStart() + 1;
        }
        int nUnionAB2 = this.sA.size() + this.sB.size() + nAdd + nDel;
        int nIntersectionAB2 = this.sA.size() + this.sB.size() - nAdd - nDel;
        this.sim = (float)nIntersectionAB2 / (float)nUnionAB2;
        this.lcs = nIntersectionAB2 / 2;
        this.add = nAdd;
        this.del = nDel;
    }

    public static List<String> listLines(Path path) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (String s : Files.readAllLines(path, EncodeDetector.charset(path))) {
                if ((s = s.replaceAll("[ \t]", "")).length() <= 0) continue;
                result.add(s);
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public String diff(Path file1, List<String> sA, Path file2, List<String> sB) {
        List<Difference> diffList = new Diff(sA, sB).diff();
        if (diffList.size() > 0) {
            StringBuilder buf = new StringBuilder();
            try {
                buf.append(String.format("--- %9s   %s\n", file1.toAbsolutePath(), Files.getLastModifiedTime(file1, new LinkOption[0])));
                buf.append(String.format("+++ %9s   %s\n", file2.toAbsolutePath(), Files.getLastModifiedTime(file2, new LinkOption[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Difference d : diffList) {
                int i;
                if (d.getDeletedEnd() >= 0) {
                    if (d.getAddedEnd() >= 0) {
                        if (d.getDeletedEnd() == d.getDeletedStart()) {
                            buf.append(d.getDeletedStart() + 1);
                        } else {
                            buf.append(String.valueOf(d.getDeletedStart() + 1) + "," + (d.getDeletedEnd() + 1));
                        }
                        buf.append('c');
                        if (d.getAddedEnd() == d.getAddedStart()) {
                            buf.append(d.getAddedStart() + 1);
                        } else {
                            buf.append(String.valueOf(d.getAddedStart() + 1) + "," + (d.getAddedEnd() + 1));
                        }
                        buf.append('\n');
                        i = d.getDeletedStart();
                        while (i <= d.getDeletedEnd()) {
                            buf.append("< " + sA.get(i));
                            buf.append('\n');
                            ++i;
                        }
                        buf.append("---\n");
                        i = d.getAddedStart();
                        while (i <= d.getAddedEnd()) {
                            buf.append("> " + sB.get(i));
                            buf.append('\n');
                            ++i;
                        }
                        continue;
                    }
                    if (d.getDeletedEnd() == d.getDeletedStart()) {
                        buf.append(d.getDeletedStart() + 1);
                    } else {
                        buf.append(String.valueOf(d.getDeletedStart() + 1) + "," + (d.getDeletedEnd() + 1));
                    }
                    buf.append('d');
                    buf.append(d.getAddedStart());
                    buf.append('\n');
                    i = d.getDeletedStart();
                    while (i <= d.getDeletedEnd()) {
                        buf.append("< " + sA.get(i));
                        buf.append('\n');
                        ++i;
                    }
                    continue;
                }
                if (d.getAddedEnd() < 0) continue;
                buf.append(d.getDeletedStart());
                buf.append('a');
                if (d.getAddedEnd() == d.getAddedStart()) {
                    buf.append(d.getAddedStart() + 1);
                } else {
                    buf.append(String.valueOf(d.getAddedStart() + 1) + "," + (d.getAddedEnd() + 1));
                }
                buf.append('\n');
                i = d.getAddedStart();
                while (i <= d.getAddedEnd()) {
                    buf.append("> " + sB.get(i));
                    buf.append('\n');
                    ++i;
                }
            }
            return buf.toString();
        }
        return "";
    }
}

