/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.graph;

import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public class SpanningTree {
    public static Group getSpanningTree(Group group, ISimilarity similarity, boolean gather) {
        if (group.gatheredFiles().size() == 1) {
            return group;
        }
        TIntHashSet unknown = new TIntHashSet((TIntCollection)group.gatheredFiles());
        int start = unknown.iterator().next();
        int maxSize = unknown.size();
        unknown.remove(start);
        TIntHashSet vNew = new TIntHashSet((int)((double)maxSize * 1.25));
        vNew.add(start);
        Group sp = new Group(group.type());
        while (vNew.size() != maxSize) {
            int newNode = -1;
            int minValue = Integer.MAX_VALUE;
            Edge minEdge = null;
            for (int vg : vNew) {
                int v = group.choose1(vg);
                for (int ug : unknown) {
                    int u = group.choose1(ug);
                    Edge gatheredEdge = new Edge(vg, ug);
                    int diffSize = similarity.getDiffSize(v, u);
                    if (diffSize == Integer.MIN_VALUE || diffSize >= minValue) continue;
                    minValue = diffSize;
                    minEdge = gatheredEdge;
                    newNode = ug;
                }
            }
            sp.addEdge(minEdge);
            vNew.add(newNode);
            unknown.remove(newNode);
        }
        if (gather) {
            sp.gather(group, sp.edges());
        } else {
            sp.noGather();
        }
        return sp;
    }
}

