/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.graph;

import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public class SpanningTreeK {
    public static Group getSpanningTree(final Group group, final ISimilarity similarity, boolean gather) {
        if (group.gatheredFiles().size() == 1) {
            return group;
        }
        int maxSize = group.gatheredFiles().size();
        THashSet forest = new THashSet((int)((double)maxSize * 1.25));
        for (int i : group.gatheredFiles()) {
            TIntHashSet t = new TIntHashSet();
            t.add(i);
            forest.add(t);
        }
        TreeSet<Edge> keys = new TreeSet<Edge>(new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                int diff2;
                int diff1 = similarity.getDiffSize(group.choose1(e1.fileId1()), group.choose1(e1.fileId2()));
                return diff1 > (diff2 = similarity.getDiffSize(group.choose1(e2.fileId1()), group.choose1(e2.fileId2()))) ? 1 : -1;
            }
        });
        keys.addAll(group.gatheredEdges());
        THashSet newEdges = new THashSet();
        while (keys.size() > 0) {
            Edge minFileInfo = keys.pollFirst();
            TIntSet tree1 = null;
            TIntSet tree2 = null;
            for (TIntSet tree : forest) {
                if (tree.contains(minFileInfo.fileId1())) {
                    tree1 = tree;
                }
                if (!tree.contains(minFileInfo.fileId2())) continue;
                tree2 = tree;
            }
            if (tree1.equals(tree2)) continue;
            forest.remove(tree1);
            forest.remove(tree2);
            TIntHashSet newTree = new TIntHashSet();
            newTree.addAll((TIntCollection)tree1);
            newTree.addAll((TIntCollection)tree2);
            forest.add(newTree);
            newEdges.add(minFileInfo);
            if (forest.size() == 1) break;
        }
        Group sp = new Group(group.type());
        if (gather) {
            sp.gather(group, (Set<Edge>)newEdges);
        } else {
            sp.noGather();
        }
        return sp;
    }
}

