/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.engine.similarity;

import gnu.trove.map.TCharObjectMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.TKJavaDiff;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.ASim;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.WordReduce;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class SimTKJavaDiffWR
extends ASim {
    public SimTKJavaDiffWR(ISimilarity diffmap, Collection<FileInfo> files, TCharObjectMap<WordReduce> wrs, float threshold) {
        super(diffmap, files, wrs, threshold);
    }

    @Override
    protected void calc(Collection<FileInfo> addedFiles) {
        ParaRun<Calc> para = new ParaRun<Calc>();
        for (FileInfo fii : addedFiles) {
            para.add(new Calc(fii, this.files));
        }
        para.run2();
    }

    @Override
    protected void calcAll() {
        ParaRun<Calc> para = new ParaRun<Calc>();
        for (FileInfo fi : this.files) {
            para.add(new Calc(fi, this.files));
        }
        para.run2();
    }

    private class Calc
    implements Runnable {
        private FileInfo target;
        private Collection<FileInfo> others;

        public Calc(FileInfo target, Collection<FileInfo> others) {
            this.target = target;
            this.others = others;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TKJavaDiff diff = new TKJavaDiff();
            Path file1 = Paths.get(this.target.preSim);
            int f1id = this.target.fileId();
            char file1type = this.target.type();
            List<String> sA = TKJavaDiff.listLines(file1);
            WordReduce wr = (WordReduce)SimTKJavaDiffWR.this.wrs.get(file1type);
            boolean pre = this.target.preSim.equals(this.target.preDiff);
            for (FileInfo other : this.others) {
                int f2id = other.fileId();
                if (f1id <= f2id || file1type != other.type() || this.target.projectId() == other.projectId()) continue;
                Path file2 = Paths.get(other.preSim);
                Edge edge = new Edge(f1id, f2id);
                if (SimTKJavaDiffWR.this.overSize(file1, file2) || SimTKJavaDiffWR.this.diffmap.getSimilarity(edge) != -2.2f || !(wr.maxSim(this.target, other) >= SimTKJavaDiffWR.this.threshold)) continue;
                diff.set(sA, file2);
                ISimilarity iSimilarity = SimTKJavaDiffWR.this.diffmap;
                synchronized (iSimilarity) {
                    SimTKJavaDiffWR.this.diffmap.setSimilarity(edge, diff.similarity());
                }
                if (!pre || !other.preSim.equals(other.preDiff)) continue;
                iSimilarity = SimTKJavaDiffWR.this.diffmap;
                synchronized (iSimilarity) {
                    SimTKJavaDiffWR.this.diffmap.setIncDec(edge, diff.del(), diff.add());
                }
            }
        }
    }
}

