//Copyright (c) 2012 Tetsuya Kanda
//http://sel.ist.osaka-u.ac.jp/~t-kanda/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret;

import java.io.IOException;
import java.nio.file.Files;

import jp.ac.osaka_u.ist.sel.pret.engine.Engine;

public class MYTEST {

	private static Engine engine;

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		// cuimain2(args);

		String opt[] = new String[] { "-m", "skip", "--type", "c.conf", "-graph", "G:\\Program Files (x86)\\Graphviz2.32\\bin\\dot.exe", "-tmp",
				"F:\\tmp", "-thread", "6", "-diff", "0" };
		OptionContainer options = new OptionContainer(opt);

		// OptionContainer options = new OptionContainer(args);
		try {
			Files.createDirectories(options.tmp());
			Files.createDirectories(options.result());
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		

		engine = new Engine(options, 0.9f);
		
		engine.readProject("F:\\src\\postgresql-7.0");
		engine.readProject("F:\\src\\postgresql-7.0.1");
		engine.readProject("F:\\src\\postgresql-7.0.2");
		engine.readProject("F:\\src\\postgresql-7.0.3");
		
		engine.saveTarget();
		
		engine.calcDiff();
		
		engine.saveTarget();
		engine.count();
		
		engine.resetThreshold(0.95f);
		engine.count();
		engine.resetThreshold(1.0f);
		engine.count();

		engine.resetThreshold(0.8f);
		engine.count();
		
		engine.resetThreshold(0.85f);
		engine.count();
	}
}
