//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//http://sel.ist.osaka-u.ac.jp/~t-kanda/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;

import jp.ac.osaka_u.ist.sel.pret.OptionContainer;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.data.SimilarityDataFactory;
import jp.ac.osaka_u.ist.sel.pret.engine.diff.CalcDiff;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.CalcSim;
import jp.ac.osaka_u.ist.sel.pret.evotree.Counter1;
import jp.ac.osaka_u.ist.sel.pret.evotree.Counter2;
import jp.ac.osaka_u.ist.sel.pret.util.Graphviz;
import jp.ac.osaka_u.ist.sel.pret.util.Save;

/**
 * Do many things
 * 
 * @author t-kanda
 * 
 */
public class Engine {

	private OptionContainer options;
	private Target target;
	private CalcSim calcSim;
	private CalcDiff calcDiff;
	private ISimilarity similarity;
	private Save save;
	private float threshold;

	/**
	 * Set up for analysis
	 * 
	 * @param options
	 */
	public Engine(OptionContainer options, float initialThreshold) {
		this.options = options;
		target = new Target(options);
		calcSim = new CalcSim(options.types().valueCollection(), options.diffType(), options.diffCommand());
		calcDiff = new CalcDiff(options.diffType(), options.diffCommand());
		similarity = SimilarityDataFactory.create(options);
		save = new Save(options.tmp());
		threshold = initialThreshold;
	}

	public void calc(Collection<FileInfo> addedFileInfo) {
		System.out.println("** CALCSIM");
		calcSim.calc(similarity, addedFileInfo, target.getCopyOfFileSet(), threshold);
	}

	/**
	 * read files under target path
	 * 
	 * @param path
	 */
	public void readProjectDirectory(String path) {
		long l1 = System.currentTimeMillis();
		System.out.print("** READ ");
		System.out.println(path);
		calc(target.readProject(Paths.get(path)));
		// target.readProject(Paths.get(path));
		long l2 = System.currentTimeMillis();

		System.out.printf("%f sec\n", (l2 - l1) / (float) 1000);
	}

	public void readProject(String path) {
		readProjectDirectory(path);
	}

	public void readProjectByFileList(String path) {
		long l1 = System.currentTimeMillis();
		System.out.print("** READ ");
		System.out.println(path);
		calc(target.readProjectByList(Paths.get(path)));

		long l2 = System.currentTimeMillis();

		System.out.printf("%f sec\n", (l2 - l1) / (float) 1000);

	}

	public void resetThreshold(float threshold) {
		if (this.threshold > threshold) {
			// new threshold is smaller. calc similarity and diff.
			this.threshold = threshold;
			System.out.println("** CALCSIM");
			calcSim.calcAll(similarity, target.getCopyOfFileSet(), threshold);
			calcDiff();
		} else {
			this.threshold = threshold;
		}
	}

	/**
	 * calc diff
	 */
	public void calcDiff() {
		// System.out.println("** CALCDIFF");
		// calcDiff.calcAll(similarity, target.getCopyOfFileSet(), threshold);
	}

	/**
	 * get cost function between projects and drow the Product Evolution Tree
	 */
	public void count() {
		{
			Counter1 ssss = new Counter1(target, similarity);
			ssss.count(threshold);
			Path output = Paths.get(options.result().toString(), Float.toString(threshold) + ".dot");

			Path dot = ssss.output(options.result());

			try {
				Files.move(dot, output, StandardCopyOption.REPLACE_EXISTING);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if (options.graphvizPath() != null) {
				Graphviz g = new Graphviz(options.graphvizPath());
				g.graphViz(output, options.result());
			}
		}
		{
			Counter2 ssss = new Counter2(target, similarity);
			ssss.count(threshold);
			Path output = Paths.get(options.result().toString(), Float.toString(threshold) + "_2.dot");

			Path dot = ssss.output(options.result());

			try {
				Files.move(dot, output, StandardCopyOption.REPLACE_EXISTING);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if (options.graphvizPath() != null) {
				Graphviz g = new Graphviz(options.graphvizPath());
				g.graphViz(output, options.result());
			}
		}
	}

	public void saveTarget() {
		save.saveObject(target, "target");
		save.saveObject(calcSim, "calc");
		save.saveObject(similarity, "sim");
	}

	public void loadTarget() {
		this.target = (Target) save.loadObject("target");
		this.calcSim = (CalcSim) save.loadObject("calc");
		this.similarity = (ISimilarity) save.loadObject("sim");
	}

	public void printfdata(int i) {
		FileInfo fi = target.getFile(i);
		System.out.printf("%3d %3d %s\r\n", fi.projectId(), i, fi.path());
	}

	public void printProjects() {
		int p = target.numberOfProject();
		for (int i = 0; i < p; i++) {
			System.out.printf("%3d %s\r\n", i, target.getProjectPath(i));
		}
	}
}
