//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.data;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

/**
 * information about directory and its file
 * 
 * @author t-kanda
 * 
 */
public class DirectoryInfo implements Serializable {
	private static final long serialVersionUID = -3645969748302556969L;
	private int projectId;
	private URI path;
	//private DirectoryInfo parent;
	private Set<DirectoryInfo> subdir;
	private TIntSet files;

	public DirectoryInfo(Path target, int projectId, DirectoryInfo parent) {
		this.projectId = projectId;
		this.path = target.toUri();
		subdir = new THashSet<>();
		files = new TIntHashSet();
		//this.parent = parent;
	}

//	public DirectoryInfo getParentDirectory() {
//		return parent;
//	}

	public synchronized boolean addFile(int fid) {
		return files.add(fid);
	}

	public TIntSet files() {
		return files;
	}

	public TIntSet allFiles() {
		TIntSet all = new TIntHashSet(files);
		for (DirectoryInfo child : subdir) {
			all.addAll(child.allFiles());
		}
		return all;
	}

	public int numberOfFiles() {
		return files.size();
	}

	public boolean addDirectory(DirectoryInfo child) {
		return subdir.add(child);
	}

	public Set<DirectoryInfo> getSubdirectories() {
		return subdir;
	}

	public int projectId() {
		return projectId;
	}

	public String getName() {
		return Paths.get(path).getFileName().toString();
	}

	public URI getPath() {
		return path;
	}
}