//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;

import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;

public class CalcDiff {
	private Path diffCommand;
	private int diffType;

	private static final int LCS_J = 0;
	private static final int DIFF_J = 1;
	private static final int DIFF_COM = 5;
	private static final int DIFF_CYG = 6;

	public CalcDiff(int diffType, Path path) {
		this.diffCommand = path;
		this.diffType = diffType;
		if (diffType >= 5) {
			if (diffCommand != null && Files.isExecutable(diffCommand)) {
				this.diffCommand = path;
			} else {
				this.diffType = LCS_J;
			}
		}
	}

	public void calcAll(ISimilarity similarity, Collection<FileInfo> files, float threshold) {
		ADiff diff;

		switch (diffType) {
		case DIFF_COM:
			diff = new DiffCommandDiff(similarity, diffCommand.toString(), threshold);
		case DIFF_CYG:
			diff = new DiffCygwinDiff(similarity, diffCommand.toString(), threshold);
		case DIFF_J:
		case LCS_J:
		default:
			diff = new DiffTKJavaDiff(similarity, threshold);
		}

		diff.calcAll(files);
	}

}
