//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.similarity;

import gnu.trove.map.TCharObjectMap;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.similarity.WordReduce.WRDiffLike;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

public class SimWROnly extends ASim {

	public SimWROnly(ISimilarity diffmap, Collection<FileInfo> files, TCharObjectMap<WordReduce> wrs, float threshold) {
		super(diffmap, files, wrs, threshold);
	}

	protected void calc(Collection<FileInfo> addedFiles) {
		ParaRun<Calc> para = new ParaRun<>();

		for (FileInfo fii : addedFiles) {
			para.add(new Calc(fii, files));
		}

		para.run2();
		return;
	}

	protected void calcAll() {
		ParaRun<Calc> para = new ParaRun<>();

		for (FileInfo fi : files) {
			para.add(new Calc(fi, files));
		}

		para.run2();
	}

	private class Calc implements Runnable {

		private FileInfo target;
		private Collection<FileInfo> others;

		public Calc(FileInfo target, Collection<FileInfo> others) {
			this.target = target;
			this.others = others;
		}

		@Override
		public void run() {

			Path file1 = Paths.get(target.preSim);
			int f1id = target.fileId();
			char file1type = target.type();
			WordReduce wr = wrs.get(file1type);
			WRDiffLike diff = wr.new WRDiffLike();
			boolean pre = target.preSim.equals(target.preDiff);

			for (FileInfo other : others) {
				int f2id = other.fileId();
				if (f1id > f2id && file1type == other.type() && target.projectId() != other.projectId()) {
					Path file2 = Paths.get(other.preSim);
					Edge edge = new Edge(f1id, f2id);
					if (!overSize(file1, file2) && diffmap.getSimilarity(edge) == ISimilarity.NOVALUE) {
						diff.set(target, other);
						float msim = diff.similarity();
						if (msim >= threshold) {
							synchronized (diffmap) {
								diffmap.setSimilarity(edge, diff.similarity());
							}
							if (pre && other.preSim.equals(other.preDiff)) {
								synchronized (diffmap) {
									// edge(v1,v2) is defined as v1.id < v2.id.
									// f1.id > f2.id here so we exchange add and
									// del
									diffmap.setIncDec(edge, diff.del(), diff.add());
								}
							}
						}
					}
				}
			}
		}
	}
}
