//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.evotree;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

import jp.ac.osaka_u.ist.sel.pret.engine.Target;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectedEdge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.DirectedGroup;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Edge;
import jp.ac.osaka_u.ist.sel.pret.engine.data.FileInfo;
import jp.ac.osaka_u.ist.sel.pret.engine.data.Group;
import jp.ac.osaka_u.ist.sel.pret.engine.data.ISimilarity;
import jp.ac.osaka_u.ist.sel.pret.engine.graph.Dot;
import jp.ac.osaka_u.ist.sel.pret.engine.graph.SpanningTree;
import jp.ac.osaka_u.ist.sel.pret.util.ParaRun;

/**
 * cost: number of similar files between projects<br>
 * direction: size
 * 
 * @author t-kanda
 * 
 */
public class Counter1 extends Counter {
	private float threshold;

	private TObjectIntMap<Edge> count;
	private TObjectIntMap<Edge> incCount;
	private TObjectIntMap<Edge> decCount;

	public Counter1(Target target, ISimilarity similarity) {
		super(target, similarity);

		count = new TObjectIntHashMap<>();
		incCount = new TObjectIntHashMap<>();
		decCount = new TObjectIntHashMap<>();
	}

	public void count(float threshold) {
		this.threshold = threshold;
		ParaRun<Cost> para = new ParaRun<>();
		int p = target.numberOfProject();
		for (int i = 1; i <= p; i++) {
			for (int j = i + 1; j <= p; j++) {
				para.add(new Cost(i, j, threshold));
			}
		}
		para.run();
		for (Edge e : count.keySet()) {
			System.out.println(e + " " + count.get(e));
		}
	}

	private class Cost implements Runnable {
		private int p1, p2;
		private float threshold;

		public Cost(int p1, int p2, float threshold) {
			this.p1 = p1;
			this.p2 = p2;
			this.threshold = threshold;
		}

		public void run() {
			int count = 0;
			int inc = 0;
			int dec = 0;

			for (TIntIterator it1 = target.getFileIDsInProject(p1).iterator(); it1.hasNext();) {
				FileInfo fi1 = target.getFile(it1.next());
				for (TIntIterator it2 = target.getFileIDsInProject(p2).iterator(); it2.hasNext();) {
					FileInfo fi2 = target.getFile(it2.next());

					Edge edge = new Edge(fi1.fileId(), fi2.fileId());
					if (similarityMap.getSimilarity(edge) >= threshold) {
						count--;
						inc += similarityMap.getInc(edge);
						dec += similarityMap.getDec(edge);
					}
				}
			}

			Edge p = new Edge(p1, p2);
			synchronized (Counter1.this.count) {
				Counter1.this.count.put(p, count);
			}
			synchronized (incCount) {
				incCount.put(p, inc);
			}
			synchronized (decCount) {
				decCount.put(p, dec);
			}
		}
	}

	public Path output(Path outputdir) {

		DummysForApp dummy = new DummysForApp();
		ISimilarity s = dummy.new DummySimilarity(count);
		Group g = new Group('A');
		for (Edge e : count.keySet()) {
			g.addEdge(e);
		}
		g.noGather();
		Group sp = SpanningTree.getSpanningTree(g, s, false);

		Set<DirectedEdge> de = new THashSet<>();
		for (Edge e : sp.edges()) {
			int p1 = e.fileId1();
			int p2 = e.fileId2();
			int fw = incCount.get(e);
			int bw = decCount.get(e);
			if (fw > bw) {
				de.add(new DirectedEdge(p1, p2));
			} else if (fw < bw) {
				de.add(new DirectedEdge(p2, p1));
			} else {
				de.add(new DirectedEdge(p1, p2, false));
			}
		}

		try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(outputdir.toString(), Float.toString(threshold) + ".txt"), Charset.defaultCharset())) {
			for (Edge e : count.keySet()) {
				bw.write(e + " " + count.get(e));
				bw.newLine();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}

		return Dot.dot(outputdir, 1, new DirectedGroup(sp, de), dummy.new Dummytarget(sp, target), s);

	}

	public Path output2(Path outputdir) {

		DummysForApp dummy = new DummysForApp();
		ISimilarity s = dummy.new DummySimilarity(count);
		Group g = new Group('A');
		for (Edge e : count.keySet()) {
			g.addEdge(e);
		}
		g.noGather();

		Set<DirectedEdge> de = new THashSet<>();
		for (Edge e : g.edges()) {
			int p1 = e.fileId1();
			int p2 = e.fileId2();
			int fw = incCount.get(e);
			int bw = decCount.get(e);
			if (fw > bw) {
				de.add(new DirectedEdge(p1, p2));
			} else if (fw < bw) {
				de.add(new DirectedEdge(p2, p1));
			} else {
				de.add(new DirectedEdge(p1, p2, false));
			}
		}

		return Dot.dot(outputdir, 1, new DirectedGroup(g, de), dummy.new Dummytarget(g, target), s);

	}

}
