/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Sony Corp. and Kazumasa Utashiro of Software Research Associates, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: $Hdr: fnt.c,v 4.300 91/06/09 06:14:43 root Rel41 $ SONY
 *
 *	@(#)fnt.c	8.1 (Berkeley) 6/10/93
 */

#ifdef CPU_SINGLE
# define ipc_phys(x)	(x)
#else /* CPU_SINGLE */
# include <sys/param.h>
# include <news3400/ipc/newsipc.h>
# ifdef mips
#  define ipc_phys(x)	K0_TT0(x)
# else /* mips */
#  define ipc_phys(x)	((int)(x) & ~0x80000000)
# endif /* mips */
#endif /* CPU_SINGLE */

char ext_fnt[][32] = {
	{
		/* 0x00 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x01 */
		0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x38, 0x00, 
		0x7c, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00, 
		0x7c, 0x00, 0x7c, 0x00, 0x38, 0x00, 0x38, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x02 */
		0x92, 0x00, 0x92, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x92, 0x00, 0x92, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x92, 0x00, 0x92, 0x00, 0x44, 0x00, 0x44, 0x00,
		0x92, 0x00, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x03 */
		0x00, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 
		0xf8, 0x00, 0x88, 0x00, 0x88, 0x00, 0x88, 0x00, 
		0x00, 0x00, 0x3e, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
	},
	{
		/* 0x04 */
		0x00, 0x00, 0xf8, 0x00, 0x80, 0x00, 0x80, 0x00, 
		0xf0, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
		0x3e, 0x00, 0x20, 0x00, 0x20, 0x00, 0x3c, 0x00,
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0x05 */
		0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x88, 0x00, 0x70, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x22, 0x00, 0x22, 0x00,
		0x3c, 0x00, 0x28, 0x00, 0x24, 0x00, 0x22, 0x00,
	},
	{
		/* 0x06 */
		0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xf8, 0x00, 
		0x00, 0x00, 0x3e, 0x00, 0x20, 0x00, 0x20, 0x00,
		0x3c, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
	},
	{
		/* 0x07 */
		0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x08 */
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0xfe, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
		0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x09 */
		0x00, 0x00, 0x84, 0x00, 0xc4, 0x00, 0xa4, 0x00, 
		0xa4, 0x00, 0x94, 0x00, 0x94, 0x00, 0x8c, 0x00, 
		0x84, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x3e, 0x00,
	},
	{
		/* 0x0a */
		0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x88, 0x00, 
		0x88, 0x00, 0x50, 0x00, 0x50, 0x00, 0x20, 0x00, 
		0x00, 0x00, 0x3e, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00,
	},
	{
		/* 0x0b */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x0c */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf0, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x0d */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x1f, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x0e */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x0f */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0xff, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x10 */
		0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x11 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x12 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x13 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x14 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
	},
	{
		/* 0x15 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x1f, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x16 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0xf0, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x17 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x18 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x19 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x1a */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x0c, 0x00, 0x30, 0x00, 0xc0, 0x00, 
		0x30, 0x00, 0x0c, 0x00, 0x02, 0x00, 0xfe, 0x00,
		0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x1b */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x00, 0x60, 0x00, 0x18, 0x00, 0x06, 0x00, 
		0x18, 0x00, 0x60, 0x00, 0x80, 0x00, 0xfe, 0x00,
		0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x1c */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 
		0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00,
		0x44, 0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x1d */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0xfe, 0x00, 0x20, 0x00, 0x40, 0x00,
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x1e */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x7c, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x3c, 0x00, 0x52, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0x1f */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x20 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x21 '!' */
		0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 
		0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x10, 0x00, 0x38, 0x00, 0x10, 0x00,
	},
	{
		/* 0x22 '"' */
		0x6c, 0x00, 0x6c, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x23 '#' */
		0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x12, 0x00, 
		0x7f, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0x24, 0x00, 0x24, 0x00, 0xfe, 0x00, 0x48, 0x00,
		0x48, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0x00,
	},
	{
		/* 0x24 '$' */
		0x10, 0x00, 0x38, 0x00, 0x54, 0x00, 0x92, 0x00, 
		0x96, 0x00, 0x90, 0x00, 0x50, 0x00, 0x38, 0x00, 
		0x14, 0x00, 0x12, 0x00, 0xd2, 0x00, 0x92, 0x00,
		0x94, 0x00, 0x78, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x25 '%' */
		0x02, 0x00, 0x62, 0x00, 0x94, 0x00, 0x94, 0x00, 
		0x94, 0x00, 0x98, 0x00, 0x68, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x2c, 0x00, 0x32, 0x00, 0x52, 0x00,
		0x52, 0x00, 0x52, 0x00, 0x8c, 0x00, 0x80, 0x00,
	},
	{
		/* 0x26 '&' */
		0x00, 0x00, 0x30, 0x00, 0x48, 0x00, 0x48, 0x00, 
		0x48, 0x00, 0x50, 0x00, 0x20, 0x00, 0x2e, 0x00, 
		0x54, 0x00, 0x54, 0x00, 0x94, 0x00, 0x88, 0x00,
		0x8c, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x27 ''' */
		0xe0, 0x00, 0xe0, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x28 '(' */
		0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x04, 0x00, 0x02, 0x00,
	},
	{
		/* 0x29 ')' */
		0x80, 0x00, 0x40, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x20, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00,
	},
	{
		/* 0x2a '*' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
		0x38, 0x00, 0x92, 0x00, 0xd6, 0x00, 0x38, 0x00, 
		0xd6, 0x00, 0x92, 0x00, 0x38, 0x00, 0x10, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x2b '+' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x2c ',' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
		0xe0, 0x00, 0x20, 0x00, 0x20, 0x00, 0xc0, 0x00,
	},
	{
		/* 0x2d '-' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x2e '.' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
		0xe0, 0x00, 0xe0, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0x2f '/' */
		0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x20, 0x00,
		0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0x80, 0x00,
	},
	{
		/* 0x30 '0' */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x24, 0x00, 0x24, 0x00, 0x18, 0x00, 0x00, 0x00,
	},
	{
		/* 0x31 '1' */
		0x00, 0x00, 0x10, 0x00, 0x70, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x32 '2' */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x42, 0x00, 
		0x62, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x22, 0x00,
		0x42, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x33 '3' */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x02, 0x00, 0x04, 0x00, 0x38, 0x00, 
		0x04, 0x00, 0x02, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x34 '4' */
		0x00, 0x00, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 
		0x28, 0x00, 0x48, 0x00, 0x48, 0x00, 0x88, 0x00, 
		0x88, 0x00, 0xfe, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x35 '5' */
		0x00, 0x00, 0xfc, 0x00, 0x80, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xb8, 0x00, 0xc4, 0x00, 0x82, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0xc2, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x36 '6' */
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x46, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0xb8, 0x00, 0xc4, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x37 '7' */
		0x00, 0x00, 0xfe, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
	},
	{
		/* 0x38 '8' */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x44, 0x00, 0x38, 0x00, 
		0x44, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x39 '9' */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x46, 0x00, 
		0x3a, 0x00, 0x02, 0x00, 0x02, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x3a ':' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x3b ';' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
		0x38, 0x00, 0x18, 0x00, 0x10, 0x00, 0x30, 0x00,
	},
	{
		/* 0x3c '<' */
		0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 
		0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x04, 0x00, 0x04, 0x00, 0x02, 0x00,
	},
	{
		/* 0x3d '=' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x3e '>' */
		0x80, 0x00, 0x40, 0x00, 0x40, 0x00, 0x20, 0x00, 
		0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00,
		0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00,
	},
	{
		/* 0x3f '?' */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0xc2, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 
		0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x10, 0x00, 0x38, 0x00, 0x10, 0x00,
	},
	{
		/* 0x40 '@' */
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x82, 0x00, 
		0x9a, 0x00, 0xa6, 0x00, 0xa2, 0x00, 0xa2, 0x00, 
		0xa2, 0x00, 0xa6, 0x00, 0x9a, 0x00, 0x80, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x41 'A' */
		0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x28, 0x00, 
		0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x7c, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x42 'B' */
		0x00, 0x00, 0xf8, 0x00, 0x44, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x44, 0x00, 0x78, 0x00, 
		0x44, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x43 'C' */
		0x00, 0x00, 0x3a, 0x00, 0x46, 0x00, 0x42, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x82, 0x00, 0x42, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x44 'D' */
		0x00, 0x00, 0xf8, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x44, 0x00,
		0x44, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x45 'E' */
		0x00, 0x00, 0xfe, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x40, 0x00, 0x48, 0x00, 0x48, 0x00, 0x78, 0x00, 
		0x48, 0x00, 0x48, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x46 'F' */
		0x00, 0x00, 0xfe, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x40, 0x00, 0x48, 0x00, 0x48, 0x00, 0x78, 0x00, 
		0x48, 0x00, 0x48, 0x00, 0x40, 0x00, 0x40, 0x00,
		0x40, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x47 'G' */
		0x00, 0x00, 0x1a, 0x00, 0x26, 0x00, 0x42, 0x00, 
		0x40, 0x00, 0x80, 0x00, 0x80, 0x00, 0x8f, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x42, 0x00,
		0x66, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x48 'H' */
		0x00, 0x00, 0xe7, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x7e, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x49 'I' */
		0x00, 0x00, 0xfe, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x4a 'J' */
		0x00, 0x00, 0x1f, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x4b 'K' */
		0x00, 0x00, 0xe6, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x48, 0x00, 0x48, 0x00, 0x70, 0x00, 0x50, 0x00, 
		0x48, 0x00, 0x48, 0x00, 0x44, 0x00, 0x44, 0x00,
		0x42, 0x00, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x4c 'L' */
		0x00, 0x00, 0xf0, 0x00, 0x40, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x40, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x4d 'M' */
		0x00, 0x00, 0x82, 0x00, 0xc6, 0x00, 0xaa, 0x00, 
		0xaa, 0x00, 0xaa, 0x00, 0x92, 0x00, 0x92, 0x00, 
		0x92, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x4f 'N' */
		0x00, 0x00, 0x87, 0x00, 0xc2, 0x00, 0xa2, 0x00, 
		0xa2, 0x00, 0xa2, 0x00, 0x92, 0x00, 0x92, 0x00, 
		0x92, 0x00, 0x8a, 0x00, 0x8a, 0x00, 0x8a, 0x00,
		0x86, 0x00, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x50 'O' */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x51 'P' */
		0x00, 0x00, 0xf8, 0x00, 0x44, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x44, 0x00, 
		0x78, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
		0x40, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x51 'Q' */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0xba, 0x00, 0x44, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x08, 0x00, 0x06, 0x00,
	},
	{
		/* 0x52 'R' */
		0x00, 0x00, 0xf8, 0x00, 0x44, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x44, 0x00, 0x78, 0x00, 
		0x48, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00,
		0x42, 0x00, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x53 'S' */
		0x00, 0x00, 0x34, 0x00, 0x4c, 0x00, 0x84, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x60, 0x00, 0x18, 0x00, 
		0x04, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0xc4, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x54 'T' */
		0x00, 0x00, 0xfe, 0x00, 0x92, 0x00, 0x92, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x55 'U' */
		0x00, 0x00, 0xe7, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x56 'V' */
		0x00, 0x00, 0xc6, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x44, 0x00, 0x28, 0x00, 0x28, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x57 'W' */
		0x00, 0x00, 0xc6, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x92, 0x00, 0x92, 0x00, 0x92, 0x00, 
		0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, 0x44, 0x00,
		0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x58 'X' */
		0x00, 0x00, 0xee, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x10, 0x00, 0x28, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x44, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x59 'Y' */
		0x00, 0x00, 0xc6, 0x00, 0x82, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x44, 0x00, 0x28, 0x00, 0x28, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x5a 'Z' */
		0x00, 0x00, 0xfe, 0x00, 0x84, 0x00, 0x88, 0x00, 
		0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x20, 0x00, 0x20, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x82, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x5b '[' */
		0x1e, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x1e, 0x00,
	},
	{
		/* 0x5c 'Back slash' */
		0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x08, 0x00, 0x08, 0x00, 0x04, 0x00,
		0x04, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
	},
	{
		/* 0x5d ']' */
		0xf0, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0xf0, 0x00,
	},
	{
		/* 0x5e '^' */
		0x10, 0x00, 0x28, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x5f '_' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00,
	},
	{
		/* 0x60 '`' */
		0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x61 'a' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x02, 0x00, 
		0x3e, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x86, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x62 'b' */
		0x00, 0x00, 0xc0, 0x00, 0x40, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x78, 0x00, 0x44, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x44, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x63 'c' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3a, 0x00, 0x46, 0x00, 0x82, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x82, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x64 'd' */
		0x00, 0x00, 0x06, 0x00, 0x04, 0x00, 0x04, 0x00, 
		0x04, 0x00, 0x3c, 0x00, 0x44, 0x00, 0x84, 0x00, 
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x84, 0x00,
		0x44, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x65 'e' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0xfe, 0x00, 0x80, 0x00, 0x80, 0x00, 0x82, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x66 'f' */
		0x00, 0x00, 0x0e, 0x00, 0x11, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0xfe, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x67 'g' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3b, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x38, 0x00, 0x40, 0x00, 0x78, 0x00,
		0x84, 0x00, 0x82, 0x00, 0x82, 0x00, 0x7c, 0x00,
	},
	{
		/* 0x68 'h' */
		0x00, 0x00, 0xc0, 0x00, 0x40, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x5c, 0x00, 0x62, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x69 'i' */
		0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x6a 'j' */
		0x06, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3e, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
		0x82, 0x00, 0x82, 0x00, 0x44, 0x00, 0x38, 0x00,
	},
	{
		/* 0x6b 'k' */
		0x00, 0x00, 0xc0, 0x00, 0x40, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x42, 0x00, 0x44, 0x00, 0x48, 0x00, 
		0x58, 0x00, 0x64, 0x00, 0x44, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x6c 'l' */
		0x00, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x6d 'm' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x6c, 0x00, 0x92, 0x00, 0x92, 0x00, 
		0x92, 0x00, 0x92, 0x00, 0x92, 0x00, 0x92, 0x00,
		0x92, 0x00, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x6e 'n' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xdc, 0x00, 0x62, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x6f 'o' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x70 'p' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xf8, 0x00, 0x44, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x44, 0x00,
		0x78, 0x00, 0x40, 0x00, 0x40, 0x00, 0xf0, 0x00,
	},
	{
		/* 0x71 'q' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3e, 0x00, 0x44, 0x00, 0x84, 0x00, 
		0x84, 0x00, 0x84, 0x00, 0x84, 0x00, 0x44, 0x00,
		0x3c, 0x00, 0x04, 0x00, 0x04, 0x00, 0x1e, 0x00,
	},
	{
		/* 0x72 'r' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xec, 0x00, 0x32, 0x00, 0x22, 0x00, 
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
		0x20, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x73 's' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3a, 0x00, 0x46, 0x00, 0x42, 0x00, 
		0x40, 0x00, 0x3c, 0x00, 0x02, 0x00, 0x82, 0x00,
		0xc2, 0x00, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x74 't' */
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x20, 0x00, 0xfc, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x22, 0x00,
		0x22, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x75 'u' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xc6, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x46, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x76 'v' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xc6, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x28, 0x00,
		0x28, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x77 'w' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x92, 0x00, 0x92, 0x00, 0x92, 0x00, 
		0x92, 0x00, 0xaa, 0x00, 0xaa, 0x00, 0x44, 0x00,
		0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x78 'x' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xee, 0x00, 0x44, 0x00, 0x28, 0x00, 
		0x28, 0x00, 0x10, 0x00, 0x28, 0x00, 0x28, 0x00,
		0x44, 0x00, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x79 'y' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xe7, 0x00, 0x42, 0x00, 0x22, 0x00, 
		0x24, 0x00, 0x14, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x90, 0x00, 0xa0, 0x00, 0x40, 0x00,
	},
	{
		/* 0x7a 'z' */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x7e, 0x00, 0x44, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x22, 0x00,
		0x42, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x7b '{' */
		0x06, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 
		0x10, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x06, 0x00,
	},
	{
		/* 0x7c '|' */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
	},
	{
		/* 0x7d '}' */
		0xc0, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 
		0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xc0, 0x00,
	},
	{
		/* 0x7e 'Tilde' */
		0x60, 0x00, 0x92, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0x7f */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* ISO */
		/* 0xa0 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa1 */
		0x00, 0x00, 0x10, 0x00, 0x38, 0x00, 0x10, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x38, 0x00,
		0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	},
	{
		/* 0xa2 */
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x3c, 0x00, 
		0x52, 0x00, 0x92, 0x00, 0x90, 0x00, 0x90, 0x00, 
		0x90, 0x00, 0x90, 0x00, 0x90, 0x00, 0x92, 0x00,
		0x52, 0x00, 0x3c, 0x00, 0x10, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa3 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x7c, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x3c, 0x00, 0x52, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa4 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x00, 
		0xc3, 0x00, 0x7e, 0x00, 0x66, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x66, 0x00, 0x7e, 0x00, 0xc3, 0x00,
		0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa5 */
		0x82, 0x00, 0x82, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0xfe, 0x00, 0x28, 0x00, 0x10, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa6 */
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa7 */
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x40, 0x00, 
		0x20, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x02, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa8 */
		0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa9 */
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x99, 0x00, 
		0xa5, 0x00, 0xc3, 0x00, 0xc1, 0x00, 0xc1, 0x00, 
		0xc1, 0x00, 0xc3, 0x00, 0xa5, 0x00, 0x99, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xaa */
		0x00, 0x00, 0x1c, 0x00, 0x22, 0x00, 0x1e, 0x00, 
		0x22, 0x00, 0x26, 0x00, 0x1a, 0x00, 0x00, 0x00, 
		0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xab */
		0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x24, 0x00, 
		0x24, 0x00, 0x48, 0x00, 0x48, 0x00, 0x90, 0x00, 
		0x90, 0x00, 0x48, 0x00, 0x48, 0x00, 0x24, 0x00,
		0x24, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00,
	},
	{
		/* 0xac */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 
		0xfe, 0x00, 0x06, 0x00, 0x06, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xad */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 
		0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xae */
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x81, 0x00, 
		0xf9, 0x00, 0xc5, 0x00, 0xc5, 0x00, 0xf9, 0x00, 
		0xc5, 0x00, 0xc5, 0x00, 0xc5, 0x00, 0x81, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xaf */
		0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb0 */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb1 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
		0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb2 */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x04, 0x00, 
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x3c, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb3 */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x04, 0x00, 
		0x18, 0x00, 0x04, 0x00, 0x24, 0x00, 0x18, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb4 */
		0x00, 0x00, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb5 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 
		0x22, 0x00, 0x22, 0x00, 0x44, 0x00, 0x44, 0x00,
		0x6c, 0x00, 0x54, 0x00, 0x82, 0x00, 0x80, 0x00,
	},
	{
		/* 0xb6 */
		0x00, 0x00, 0x7f, 0x00, 0xfa, 0x00, 0xfa, 0x00, 
		0xfa, 0x00, 0xfa, 0x00, 0xfa, 0x00, 0x7a, 0x00, 
		0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00,
		0x0a, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb7 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb8 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x0c, 0x00, 0x08, 0x00, 0x10, 0x00,
	},
	{
		/* 0xb9 */
		0x00, 0x00, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xba */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0x24, 0x00, 0x24, 0x00, 0x18, 0x00, 0x00, 0x00, 
		0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbb */
		0x00, 0x00, 0x48, 0x00, 0x48, 0x00, 0x24, 0x00, 
		0x24, 0x00, 0x12, 0x00, 0x12, 0x00, 0x09, 0x00, 
		0x09, 0x00, 0x12, 0x00, 0x12, 0x00, 0x24, 0x00,
		0x24, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbc */
		0x00, 0x00, 0x40, 0x00, 0xc0, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x41, 0x00, 0x46, 0x00, 0x08, 0x00, 
		0x32, 0x00, 0xc6, 0x00, 0x0a, 0x00, 0x12, 0x00,
		0x1f, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbd */
		0x00, 0x00, 0x40, 0x00, 0xc0, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x41, 0x00, 0x46, 0x00, 0x08, 0x00, 
		0x36, 0x00, 0xc9, 0x00, 0x01, 0x00, 0x06, 0x00,
		0x08, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbe */
		0x00, 0x00, 0x60, 0x00, 0x90, 0x00, 0x10, 0x00, 
		0x60, 0x00, 0x11, 0x00, 0x96, 0x00, 0x68, 0x00, 
		0x32, 0x00, 0xc6, 0x00, 0x0a, 0x00, 0x12, 0x00,
		0x1f, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbf */
		0x08, 0x00, 0x1c, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 
		0x20, 0x00, 0x20, 0x00, 0x40, 0x00, 0x43, 0x00,
		0x41, 0x00, 0x22, 0x00, 0x1c, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc0 */
		0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 0x10, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x7c, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc1 */
		0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x7c, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc2 */
		0x10, 0x00, 0x28, 0x00, 0x44, 0x00, 0x10, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x7c, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc3 */
		0x24, 0x00, 0x58, 0x00, 0x00, 0x00, 0x10, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x7c, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc4 */
		0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0x10, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x7c, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc5 */
		0x38, 0x00, 0x44, 0x00, 0x38, 0x00, 0x10, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x44, 0x00, 0x7c, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc6 */
		0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x28, 0x00, 
		0x28, 0x00, 0x48, 0x00, 0x48, 0x00, 0x48, 0x00, 
		0x4e, 0x00, 0xf8, 0x00, 0x88, 0x00, 0x88, 0x00,
		0x88, 0x00, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc7 */
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x40, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x40, 0x00, 0x42, 0x00,
		0x3c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00,
	},
	{
		/* 0xc8 */
		0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 0xfe, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x40, 0x00, 0x48, 0x00, 
		0x78, 0x00, 0x48, 0x00, 0x40, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc9 */
		0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 0xfe, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x40, 0x00, 0x48, 0x00, 
		0x78, 0x00, 0x48, 0x00, 0x40, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xca */
		0x30, 0x00, 0x48, 0x00, 0x00, 0x00, 0xfe, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x40, 0x00, 0x48, 0x00, 
		0x78, 0x00, 0x48, 0x00, 0x40, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcb */
		0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0xfe, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x40, 0x00, 0x48, 0x00, 
		0x78, 0x00, 0x48, 0x00, 0x40, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcc */
		0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcd */
		0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xce */
		0x10, 0x00, 0x28, 0x00, 0x44, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcf */
		0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd0 */
		0x00, 0x00, 0xf8, 0x00, 0x44, 0x00, 0x44, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0xf2, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x44, 0x00,
		0x44, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd1 */
		0x24, 0x00, 0x58, 0x00, 0x00, 0x00, 0x87, 0x00, 
		0xc2, 0x00, 0xa2, 0x00, 0xa2, 0x00, 0x92, 0x00, 
		0x92, 0x00, 0x92, 0x00, 0x8a, 0x00, 0x8a, 0x00,
		0x86, 0x00, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd2 */
		0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 0x38, 0x00, 
		0x44, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd3 */
		0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 0x38, 0x00, 
		0x44, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd4 */
		0x38, 0x00, 0x44, 0x00, 0x00, 0x00, 0x38, 0x00, 
		0x44, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd5 */
		0x24, 0x00, 0x58, 0x00, 0x00, 0x00, 0x38, 0x00, 
		0x44, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd6 */
		0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0x38, 0x00, 
		0x44, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd7 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x81, 0x00, 0x42, 0x00, 0x24, 0x00, 0x18, 0x00, 
		0x18, 0x00, 0x24, 0x00, 0x42, 0x00, 0x81, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd8 */
		0x02, 0x00, 0x02, 0x00, 0x3c, 0x00, 0x44, 0x00, 
		0x86, 0x00, 0x8a, 0x00, 0x8a, 0x00, 0x92, 0x00, 
		0x92, 0x00, 0xa2, 0x00, 0xa2, 0x00, 0xc2, 0x00,
		0x44, 0x00, 0x78, 0x00, 0x80, 0x00, 0x80, 0x00,
	},
	{
		/* 0xd9 */
		0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 0xe7, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xda */
		0x0c, 0x00, 0x08, 0x00, 0x10, 0x00, 0xe7, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdb */
		0x18, 0x00, 0x24, 0x00, 0x00, 0x00, 0xe7, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdc */
		0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 0xe7, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdd */
		0x0c, 0x00, 0x08, 0x00, 0x10, 0x00, 0xc6, 0x00, 
		0x82, 0x00, 0x44, 0x00, 0x44, 0x00, 0x28, 0x00, 
		0x28, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xde */
		0xe0, 0x00, 0x40, 0x00, 0x78, 0x00, 0x44, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x44, 0x00, 
		0x78, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
		0x40, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdf */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x84, 0x00, 0x98, 0x00, 
		0x84, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x82, 0x00, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe0 */
		0x00, 0x00, 0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x02, 0x00, 
		0x3e, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x86, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe1 */
		0x00, 0x00, 0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x02, 0x00, 
		0x3e, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x86, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe2 */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x42, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x02, 0x00, 
		0x3e, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x86, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe3 */
		0x00, 0x00, 0x32, 0x00, 0x4c, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x02, 0x00, 
		0x3e, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x86, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe4 */
		0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x02, 0x00, 
		0x3e, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x86, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe5 */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x18, 0x00, 
		0x00, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x02, 0x00, 
		0x3e, 0x00, 0x42, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x86, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe6 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x6c, 0x00, 0x92, 0x00, 0x12, 0x00, 
		0x3e, 0x00, 0x50, 0x00, 0x90, 0x00, 0x92, 0x00,
		0x92, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe7 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x3a, 0x00, 0x46, 0x00, 0x82, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0x80, 0x00, 0x82, 0x00, 0x42, 0x00,
		0x3c, 0x00, 0x10, 0x00, 0x10, 0x00, 0x20, 0x00,
	},
	{
		/* 0xe8 */
		0x00, 0x00, 0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0xfe, 0x00, 0x80, 0x00, 0x80, 0x00, 0x82, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xe9 */
		0x00, 0x00, 0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0xfe, 0x00, 0x80, 0x00, 0x80, 0x00, 0x82, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xea */
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0xfe, 0x00, 0x80, 0x00, 0x80, 0x00, 0x82, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xeb */
		0x00, 0x00, 0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0xfe, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xec */
		0x00, 0x00, 0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 
		0x00, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xed */
		0x00, 0x00, 0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 
		0x00, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xee */
		0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x42, 0x00, 
		0x00, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xef */
		0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x78, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf0 */
		0x00, 0x00, 0x64, 0x00, 0x18, 0x00, 0x18, 0x00, 
		0x24, 0x00, 0x3c, 0x00, 0x42, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x42, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf1 */
		0x00, 0x00, 0x32, 0x00, 0x4c, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xdc, 0x00, 0x62, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x42, 0x00, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf2 */
		0x00, 0x00, 0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf3 */
		0x00, 0x00, 0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf4 */
		0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x44, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf5 */
		0x00, 0x00, 0x32, 0x00, 0x4c, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf6 */
		0x00, 0x00, 0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x82, 0x00, 
		0x82, 0x00, 0x82, 0x00, 0x82, 0x00, 0x82, 0x00,
		0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf7 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0xfe, 0x00, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf8 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x3a, 0x00, 0x44, 0x00, 0x8a, 0x00, 
		0x8a, 0x00, 0x92, 0x00, 0xa2, 0x00, 0xa2, 0x00,
		0x44, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xf9 */
		0x00, 0x00, 0x30, 0x00, 0x10, 0x00, 0x08, 0x00, 
		0x00, 0x00, 0xc6, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x46, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xfa */
		0x00, 0x00, 0x18, 0x00, 0x10, 0x00, 0x20, 0x00, 
		0x00, 0x00, 0xc6, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x46, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xfb */
		0x00, 0x00, 0x10, 0x00, 0x28, 0x00, 0x44, 0x00, 
		0x00, 0x00, 0xc6, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x46, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xfc */
		0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xc6, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x46, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xfd */
		0x00, 0x00, 0x0c, 0x00, 0x08, 0x00, 0x10, 0x00, 
		0x00, 0x00, 0xe7, 0x00, 0x42, 0x00, 0x22, 0x00, 
		0x24, 0x00, 0x14, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x90, 0x00, 0xa0, 0x00, 0x40, 0x00,
	},
	{
		/* 0xfe */
		0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x78, 0x00, 0x44, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x44, 0x00,
		0x78, 0x00, 0x40, 0x00, 0x40, 0x00, 0xf0, 0x00,
	},
	{
		/* 0xff */
		0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0xe7, 0x00, 0x42, 0x00, 0x22, 0x00, 
		0x24, 0x00, 0x14, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x90, 0x00, 0xa0, 0x00, 0x40, 0x00,
	},
	{
		/* KANA */
		/* 0xa0 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa1 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x20, 0x00, 0x50, 0x00, 0x50, 0x00, 0x20, 0x00,
	},
	{
		/* 0xa2 */
		0x1e, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa3 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00,
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x3c, 0x00,
	},
	{
		/* 0xa4 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x40, 0x00, 0x20, 0x00, 0x20, 0x00,
	},
	{
		/* 0xa5 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 
		0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa6 */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x7e, 0x00, 0x02, 0x00, 
		0x06, 0x00, 0x04, 0x00, 0x0c, 0x00, 0x08, 0x00,
		0x18, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xa7 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x02, 0x00, 
		0x16, 0x00, 0x14, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x30, 0x00, 0x20, 0x00,
	},
	{
		/* 0xa8 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 
		0x08, 0x00, 0x18, 0x00, 0x68, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
	},
	{
		/* 0xa9 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x7e, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x02, 0x00, 0x04, 0x00,
		0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00,
	},
	{
		/* 0xaa */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x7e, 0x00, 0x00, 0x00,
	},
	{
		/* 0xab */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x7e, 0x00, 0x18, 0x00, 0x18, 0x00, 0x28, 0x00,
		0x28, 0x00, 0x48, 0x00, 0x08, 0x00, 0x18, 0x00,
	},
	{
		/* 0xac */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x20, 0x00, 0x22, 0x00, 0x16, 0x00, 
		0x1a, 0x00, 0x32, 0x00, 0x48, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00,
	},
	{
		/* 0xad */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x7e, 0x00, 0x00, 0x00,
	},
	{
		/* 0xae */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x04, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x3c, 0x00, 0x04, 0x00,
		0x04, 0x00, 0x04, 0x00, 0x3c, 0x00, 0x00, 0x00,
	},
	{
		/* 0xaf */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x52, 0x00, 
		0x4a, 0x00, 0x22, 0x00, 0x04, 0x00, 0x04, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00,
	},
	{
		/* 0xb0 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb1 */
		0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x01, 0x00, 
		0x12, 0x00, 0x14, 0x00, 0x14, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x20, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb2 */
		0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 
		0x04, 0x00, 0x08, 0x00, 0x18, 0x00, 0x28, 0x00, 
		0xc8, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb3 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x7e, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00,
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb4 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb5 */
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0xff, 0x00, 0x08, 0x00, 0x18, 0x00, 0x18, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x48, 0x00, 0x48, 0x00,
		0x88, 0x00, 0x08, 0x00, 0x18, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb6 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x7e, 0x00, 0x12, 0x00, 0x12, 0x00, 0x12, 0x00, 
		0x12, 0x00, 0x12, 0x00, 0x22, 0x00, 0x22, 0x00,
		0x22, 0x00, 0x42, 0x00, 0x4e, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb7 */
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x16, 0x00, 
		0x18, 0x00, 0x30, 0x00, 0xd0, 0x00, 0x13, 0x00, 
		0x0c, 0x00, 0x38, 0x00, 0x68, 0x00, 0x08, 0x00,
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00,
	},
	{
		/* 0xb8 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x1e, 0x00, 
		0x12, 0x00, 0x22, 0x00, 0x22, 0x00, 0x44, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xb9 */
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x3f, 0x00, 0x44, 0x00, 0x44, 0x00, 0x84, 0x00, 
		0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0xba */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
		0x02, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbb */
		0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0xff, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 
		0x24, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbc */
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x30, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x41, 0x00, 0x61, 0x00, 
		0x22, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbd */
		0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x04, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x18, 0x00, 0x14, 0x00, 0x24, 0x00,
		0x22, 0x00, 0x42, 0x00, 0x81, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbe */
		0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x2e, 0x00, 0x32, 0x00, 0xe2, 0x00, 0x24, 0x00, 
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
		0x20, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xbf */
		0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x22, 0x00, 0x22, 0x00, 0x02, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc0 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x1e, 0x00, 
		0x12, 0x00, 0x22, 0x00, 0x32, 0x00, 0x4a, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc1 */
		0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x78, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0xff, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc2 */
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0xa1, 0x00, 
		0x91, 0x00, 0x51, 0x00, 0x52, 0x00, 0x42, 0x00, 
		0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc3 */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc4 */
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x18, 0x00, 0x14, 0x00, 
		0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc5 */
		0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0xff, 0x00, 0x08, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc6 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc7 */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x04, 0x00, 0x24, 0x00, 0x28, 0x00, 
		0x18, 0x00, 0x08, 0x00, 0x14, 0x00, 0x12, 0x00,
		0x22, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc8 */
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x7e, 0x00, 
		0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x18, 0x00, 
		0x34, 0x00, 0x52, 0x00, 0x91, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
	},
	{
		/* 0xc9 */
		0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 
		0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x20, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00,
	},
	{
		/* 0xca */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 
		0x24, 0x00, 0x24, 0x00, 0x22, 0x00, 0x22, 0x00, 
		0x22, 0x00, 0x22, 0x00, 0x42, 0x00, 0x41, 0x00,
		0x41, 0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcb */
		0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 
		0x46, 0x00, 0x48, 0x00, 0x70, 0x00, 0x40, 0x00, 
		0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
		0x20, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcc */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 
		0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00,
		0x20, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcd */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 
		0x30, 0x00, 0x30, 0x00, 0x48, 0x00, 0x48, 0x00, 
		0x44, 0x00, 0x84, 0x00, 0x02, 0x00, 0x02, 0x00,
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xce */
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0xff, 0x00, 0x10, 0x00, 0x10, 0x00, 0x54, 0x00, 
		0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x91, 0x00,
		0x91, 0x00, 0x10, 0x00, 0x30, 0x00, 0x00, 0x00,
	},
	{
		/* 0xcf */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 
		0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x28, 0x00, 
		0x10, 0x00, 0x18, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd0 */
		0x00, 0x00, 0x20, 0x00, 0x18, 0x00, 0x04, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
		0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd1 */
		0x00, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x20, 0x00, 0x24, 0x00, 
		0x24, 0x00, 0x24, 0x00, 0x22, 0x00, 0x4e, 0x00,
		0x72, 0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd2 */
		0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x04, 0x00, 0x24, 0x00, 0x24, 0x00, 0x18, 0x00, 
		0x08, 0x00, 0x1c, 0x00, 0x14, 0x00, 0x22, 0x00,
		0x20, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd3 */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x10, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0xfe, 0x00, 
		0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd4 */
		0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x23, 0x00, 
		0x2d, 0x00, 0x31, 0x00, 0xd2, 0x00, 0x12, 0x00, 
		0x10, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
		0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd5 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00,
		0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd6 */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x7e, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
		0x02, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd7 */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00,
		0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd8 */
		0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 
		0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 
		0x22, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00,
		0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00,
	},
	{
		/* 0xd9 */
		0x00, 0x00, 0x08, 0x00, 0x28, 0x00, 0x28, 0x00, 
		0x28, 0x00, 0x28, 0x00, 0x28, 0x00, 0x29, 0x00, 
		0x29, 0x00, 0x29, 0x00, 0x2a, 0x00, 0x4a, 0x00,
		0x4c, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xda */
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 
		0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x21, 0x00, 
		0x21, 0x00, 0x22, 0x00, 0x22, 0x00, 0x24, 0x00,
		0x28, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdb */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
		0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdc */
		0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x42, 0x00, 
		0x42, 0x00, 0x42, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00,
		0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdd */
		0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00, 
		0x10, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 
		0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00,
		0x20, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xde */
		0x28, 0x00, 0x28, 0x00, 0x28, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	{
		/* 0xdf */
		0x10, 0x00, 0x28, 0x00, 0x28, 0x00, 0x10, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	}
};

#define	ys_fnt	ext_fnt[0xa5 - 0xa0 + 128]
#define	ol_fnt	ext_fnt[0xaf - 0xa0 + 128]
#define	bs_fnt	ext_fnt['\\']
#define	ti_fnt	ext_fnt['~']

char *ext_fnt_addr[sizeof(ext_fnt) / 32];

font_jisroman()
{
	ext_fnt_addr['\\'] = (char *)ipc_phys(ys_fnt);
	ext_fnt_addr['~'] = (char *)ipc_phys(ol_fnt);
}

font_ascii()
{
	ext_fnt_addr['\\'] = (char *)ipc_phys(bs_fnt);
	ext_fnt_addr['~'] = (char *)ipc_phys(ti_fnt);
}

void
setup_fnt()
{
	register int i;

	i = sizeof(ext_fnt) / 32;
	while(--i >= 0) {
		ext_fnt_addr[i] = (char *)ipc_phys(ext_fnt[i]);
	}
}
