/*	$OpenBSD: ext2_vnops.c,v 1.3 1996/09/23 13:01:45 mickey Exp $	*/

/*
 *  modified for EXT2FS support in Lites 1.1
 *
 *  Aug 1995, Godmar Back (gback@cs.utah.edu)
 *  University of Utah, Department of Computer Science
 */
/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)ext2_vnops.c	8.7 (Berkeley) 2/3/94
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/resourcevar.h>
#include <sys/kernel.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/buf.h>
#include <sys/proc.h>
#include <sys/conf.h>
#include <sys/mount.h>
#include <sys/vnode.h>
#include <sys/malloc.h>

#include <vm/vm.h>
#include <vm/vm_extern.h>

#include <miscfs/specfs/specdev.h>
#include <miscfs/fifofs/fifo.h>

#include <sys/lockf.h>
#include <sys/signalvar.h>
#include <ufs/ufs/quota.h>
#include <ufs/ufs/inode.h>
#include <ufs/ufs/dir.h>
#include <ufs/ufs/ufs_extern.h>

#include <ufs/ffs/ffs_extern.h>

#include <gnu/ext2fs/ext2_fs.h>
#include <gnu/ext2fs/ext2_fs_sb.h>
#include <gnu/ext2fs/fs.h>
#include <gnu/ext2fs/ext2_extern.h>

int ext2_fsync __P((void *));
int ext2_reclaim __P((void *));
int ext2_read __P((void *));
int ext2_write __P((void *));

/* Global vfs data structures for ext2fs. */
int (**ext2_vnodeop_p) __P((void *));
static struct vnodeopv_entry_desc ext2_vnodeop_entries[] = {
	{ &vop_default_desc, vn_default_error },
	{ &vop_lookup_desc, ext2_lookup },	/* lookup */
	{ &vop_create_desc, ufs_create },	/* create */
	{ &vop_mknod_desc, ufs_mknod },	/* mknod */
	{ &vop_open_desc, ufs_open },		/* open */
	{ &vop_close_desc, ufs_close },	/* close */
	{ &vop_access_desc, ufs_access },	/* access */
	{ &vop_getattr_desc, ufs_getattr },	/* getattr */
	{ &vop_setattr_desc, ufs_setattr },	/* setattr */
	{ &vop_read_desc, ext2_read },		/* read */
	{ &vop_write_desc, ext2_write },	/* write */
	{ &vop_ioctl_desc, ufs_ioctl },	/* ioctl */
	{ &vop_select_desc, ufs_select },	/* select */
	{ &vop_mmap_desc, ufs_mmap },		/* mmap */
	{ &vop_fsync_desc, ext2_fsync },	/* fsync */
	{ &vop_seek_desc, ufs_seek },		/* seek */
	{ &vop_remove_desc, ufs_remove },	/* remove */
	{ &vop_link_desc, ufs_link },		/* link */
	{ &vop_rename_desc, ufs_rename },	/* rename */
	{ &vop_mkdir_desc, ufs_mkdir },	/* mkdir */
	{ &vop_rmdir_desc, ufs_rmdir },	/* rmdir */
	{ &vop_symlink_desc, ufs_symlink },	/* symlink */
	{ &vop_readdir_desc, ext2_readdir },	/* readdir */
	{ &vop_readlink_desc, ufs_readlink },	/* readlink */
	{ &vop_abortop_desc, ufs_abortop },	/* abortop */
	{ &vop_inactive_desc, ext2_inactive },	/* inactive */
	{ &vop_reclaim_desc, ext2_reclaim },	/* reclaim */
	{ &vop_lock_desc, ufs_lock },		/* lock */
	{ &vop_unlock_desc, ufs_unlock },	/* unlock */
	{ &vop_bmap_desc, ufs_bmap },		/* bmap */
	{ &vop_strategy_desc, ufs_strategy },	/* strategy */
	{ &vop_print_desc, ufs_print },	/* print */
	{ &vop_islocked_desc, ufs_islocked },	/* islocked */
	{ &vop_pathconf_desc, ufs_pathconf },	/* pathconf */
	{ &vop_advlock_desc, ufs_advlock },	/* advlock */
	{ &vop_blkatoff_desc, ext2_blkatoff },	/* blkatoff */
	{ &vop_valloc_desc, ext2_valloc },	/* valloc */
	{ &vop_reallocblks_desc, ext2_reallocblks },	/* reallocblks */
	{ &vop_vfree_desc, ext2_vfree },	/* vfree */
	{ &vop_truncate_desc, ext2_truncate },	/* truncate */
	{ &vop_update_desc, ext2_update },	/* update */
	{ &vop_bwrite_desc, vn_bwrite },	/* bwrite */
	{ (struct vnodeop_desc*)NULL, (int(*) __P((void*)))NULL }
};
static struct vnodeopv_desc ext2fs_vnodeop_opv_desc =
	{ &ext2_vnodeop_p, ext2_vnodeop_entries };

int (**ext2_specop_p) __P((void *));
static struct vnodeopv_entry_desc ext2_specop_entries[] = {
	{ &vop_default_desc, vn_default_error },
	{ &vop_lookup_desc, spec_lookup },	/* lookup */
	{ &vop_create_desc, spec_create },	/* create */
	{ &vop_mknod_desc, spec_mknod },	/* mknod */
	{ &vop_open_desc, spec_open },		/* open */
	{ &vop_close_desc, ufsspec_close },	/* close */
	{ &vop_access_desc, ufs_access },	/* access */
	{ &vop_getattr_desc, ufs_getattr },	/* getattr */
	{ &vop_setattr_desc, ufs_setattr },	/* setattr */
	{ &vop_read_desc, ufsspec_read },	/* read */
	{ &vop_write_desc, ufsspec_write },	/* write */
	{ &vop_ioctl_desc, spec_ioctl },	/* ioctl */
	{ &vop_select_desc, spec_select },	/* select */
	{ &vop_mmap_desc, spec_mmap },		/* mmap */
	{ &vop_fsync_desc, ext2_fsync },	/* fsync */
	{ &vop_seek_desc, spec_seek },		/* seek */
	{ &vop_remove_desc, spec_remove },	/* remove */
	{ &vop_link_desc, spec_link },		/* link */
	{ &vop_rename_desc, spec_rename },	/* rename */
	{ &vop_mkdir_desc, spec_mkdir },	/* mkdir */
	{ &vop_rmdir_desc, spec_rmdir },	/* rmdir */
	{ &vop_symlink_desc, spec_symlink },	/* symlink */
	{ &vop_readdir_desc, spec_readdir },	/* readdir */
	{ &vop_readlink_desc, spec_readlink },	/* readlink */
	{ &vop_abortop_desc, spec_abortop },	/* abortop */
	{ &vop_inactive_desc, ext2_inactive },	/* inactive */
	{ &vop_reclaim_desc, ext2_reclaim },	/* reclaim */
	{ &vop_lock_desc, ufs_lock },		/* lock */
	{ &vop_unlock_desc, ufs_unlock },	/* unlock */
	{ &vop_bmap_desc, spec_bmap },		/* bmap */
	{ &vop_strategy_desc, spec_strategy },	/* strategy */
	{ &vop_print_desc, ufs_print },	/* print */
	{ &vop_islocked_desc, ufs_islocked },	/* islocked */
	{ &vop_pathconf_desc, spec_pathconf },	/* pathconf */
	{ &vop_advlock_desc, spec_advlock },	/* advlock */
	{ &vop_blkatoff_desc, spec_blkatoff },	/* blkatoff */
	{ &vop_valloc_desc, spec_valloc },	/* valloc */
	{ &vop_reallocblks_desc, spec_reallocblks },	/* reallocblks */
	{ &vop_vfree_desc, ext2_vfree },	/* vfree */
	{ &vop_truncate_desc, spec_truncate },	/* truncate */
	{ &vop_update_desc, ext2_update },	/* update */
	{ &vop_bwrite_desc, vn_bwrite },	/* bwrite */
	{ (struct vnodeop_desc*)NULL, (int(*) __P((void *)))NULL }
};
static struct vnodeopv_desc ext2fs_specop_opv_desc =
	{ &ext2_specop_p, ext2_specop_entries };

#ifdef FIFO
int (**ext2_fifoop_p) __P((void *));
static struct vnodeopv_entry_desc ext2_fifoop_entries[] = {
	{ &vop_default_desc, vn_default_error },
	{ &vop_lookup_desc, fifo_lookup },	/* lookup */
	{ &vop_create_desc, fifo_create },	/* create */
	{ &vop_mknod_desc, fifo_mknod },	/* mknod */
	{ &vop_open_desc, fifo_open },		/* open */
	{ &vop_close_desc, ufsfifo_close },	/* close */
	{ &vop_access_desc, ufs_access },	/* access */
	{ &vop_getattr_desc, ufs_getattr },	/* getattr */
	{ &vop_setattr_desc, ufs_setattr },	/* setattr */
	{ &vop_read_desc, ufsfifo_read },	/* read */
	{ &vop_write_desc, ufsfifo_write },	/* write */
	{ &vop_ioctl_desc, fifo_ioctl },	/* ioctl */
	{ &vop_select_desc, fifo_select },	/* select */
	{ &vop_mmap_desc, fifo_mmap },		/* mmap */
	{ &vop_fsync_desc, ext2_fsync },	/* fsync */
	{ &vop_seek_desc, fifo_seek },		/* seek */
	{ &vop_remove_desc, fifo_remove },	/* remove */
	{ &vop_link_desc, fifo_link },		/* link */
	{ &vop_rename_desc, fifo_rename },	/* rename */
	{ &vop_mkdir_desc, fifo_mkdir },	/* mkdir */
	{ &vop_rmdir_desc, fifo_rmdir },	/* rmdir */
	{ &vop_symlink_desc, fifo_symlink },	/* symlink */
	{ &vop_readdir_desc, fifo_readdir },	/* readdir */
	{ &vop_readlink_desc, fifo_readlink },	/* readlink */
	{ &vop_abortop_desc, fifo_abortop },	/* abortop */
	{ &vop_inactive_desc, ext2_inactive },	/* inactive */
	{ &vop_reclaim_desc, ext2_reclaim },	/* reclaim */
	{ &vop_lock_desc, ufs_lock },		/* lock */
	{ &vop_unlock_desc, ufs_unlock },	/* unlock */
	{ &vop_bmap_desc, fifo_bmap },		/* bmap */
	{ &vop_strategy_desc, fifo_strategy },	/* strategy */
	{ &vop_print_desc, ufs_print },	/* print */
	{ &vop_islocked_desc, ufs_islocked },	/* islocked */
	{ &vop_pathconf_desc, fifo_pathconf },	/* pathconf */
	{ &vop_advlock_desc, fifo_advlock },	/* advlock */
	{ &vop_blkatoff_desc, fifo_blkatoff },	/* blkatoff */
	{ &vop_valloc_desc, fifo_valloc },	/* valloc */
	{ &vop_reallocblks_desc, fifo_reallocblks },	/* reallocblks */
	{ &vop_vfree_desc, ext2_vfree },	/* vfree */
	{ &vop_truncate_desc, fifo_truncate },	/* truncate */
	{ &vop_update_desc, ext2_update },	/* update */
	{ &vop_bwrite_desc, vn_bwrite },	/* bwrite */
	{ (struct vnodeop_desc*)NULL, (int(*) __P((void *)))NULL }
};
static struct vnodeopv_desc ext2fs_fifoop_opv_desc =
	{ &ext2_fifoop_p, ext2_fifoop_entries };
#endif /* FIFO */

#ifdef DEBUG
#ifndef FFS
/*
 * Enabling cluster read/write operations.
 */
#include <sys/sysctl.h>
int doclusterread = 1;
struct ctldebug debug11 = { "doclusterread", &doclusterread };
int doclusterwrite = 1;
struct ctldebug debug12 = { "doclusterwrite", &doclusterwrite };
#else
extern int doclusterread;
extern int doclusterwrite;
#endif
#else
/* XXX for ufs_readwrite */
#define doclusterread 1
#define doclusterwrite 1
#endif

#define EXT2_READWRITE
#include <ufs/ufs/ufs_readwrite.c>

/*
 * Synch an open file.
 */
/* ARGSUSED */
int
ext2_fsync(v)
	void *v;
{
	struct vop_fsync_args /* {
		struct vnode *a_vp;
		struct ucred *a_cred;
		int a_waitfor;
		struct proc *a_p;
	} */ *ap = v;
	register struct vnode *vp = ap->a_vp;
	struct timespec ts;

	/*
	 * Flush all dirty buffers associated with a vnode.
	 */
	ext2_discard_prealloc(VTOI(vp));

	vflushbuf(vp, ap->a_waitfor == MNT_WAIT);
	TIMEVAL_TO_TIMESPEC(&time, &ts);
	return (VOP_UPDATE(ap->a_vp, &ts, &ts, ap->a_waitfor == MNT_WAIT));
}

/*
 * Reclaim an inode so that it can be used for other purposes.
 */
int
ext2_reclaim(v)
	void *v;
{
	struct vop_reclaim_args /* {
		struct vnode *a_vp;
	} */ *ap = v;
	register struct vnode *vp = ap->a_vp;
	int error;

	if ((error = ufs_reclaim(vp)) != 0)
		return (error);
	FREE(vp->v_data, M_EXT2FSNODE);
	vp->v_data = NULL;
	return (0);
}
