/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.log.LogEntry;
import amida.log.LogFileName;
import amida.log.MethodCallEntry;
import amida.log.TextLogLineParser;
import amida.log.java.JavaTypeManager;
import amida.logmanager.AmidaProperty;
import amida.util.FileRangeInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PhaseSummaryWindow {
    private static Shell currentShell;
    private static int eventsInWindow;

    static {
        eventsInWindow = -1;
    }

    public static void closeCurrentWindow() {
        if (currentShell != null) {
            currentShell.dispose();
            currentShell = null;
        }
    }

    public static Shell open(Shell parent, String title, LogFileName phaselog, Point pos) {
        currentShell = new Shell(parent, 116);
        currentShell.setText(title);
        currentShell.setLayout((Layout)new FillLayout());
        currentShell.setLocation(pos);
        if (eventsInWindow == -1) {
            eventsInWindow = AmidaProperty.getInstance().getPhaseMethodCountForSummaryWindow();
        }
        Text text = new Text((Composite)currentShell, 2882);
        text.setText(PhaseSummaryWindow.loadHeadEvents(phaselog, eventsInWindow));
        Point size = currentShell.computeSize(-1, -1);
        if (size.y > text.getLineHeight() * 12) {
            size.y = text.getLineHeight() * 12;
        }
        currentShell.setSize(size);
        currentShell.setVisible(true);
        return currentShell;
    }

    public static String loadHeadEvents(LogFileName f, int numEvents) {
        try {
            ArrayList<String> items = new ArrayList<String>(numEvents);
            Reader r = f.isPhaseSpecified() ? new InputStreamReader(new FileRangeInputStream(new FileInputStream(f.getFileObject()), f.getPhaseBegin(), f.getPhaseEnd())) : new BufferedReader(new FileReader(f.getLogfile()));
            LineNumberReader reader = new LineNumberReader(r);
            TextLogLineParser parser = new TextLogLineParser(new JavaTypeManager());
            String l = reader.readLine();
            while (l != null && items.size() < numEvents) {
                MethodCallEntry call;
                String sig;
                LogEntry entry = parser.parseLine(l);
                if (entry instanceof MethodCallEntry && !items.contains(sig = String.valueOf((call = (MethodCallEntry)entry).getFullClassName()) + "#" + call.getMethodName())) {
                    items.add(sig);
                }
                l = reader.readLine();
            }
            reader.close();
            StringBuilder builder = new StringBuilder();
            for (String s : items) {
                builder.append(s);
                builder.append("\n");
            }
            return builder.toString();
        }
        catch (IOException e) {
            return "";
        }
    }
}

