/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.gui.TableManager;
import amida.log.LogFileName;
import amida.logmanager.AmidaProperty;
import amida.logmanager.Logger;
import amida.logmanager.PhaseDetectionLauncherWindow;
import amida.logmanager.PhaseDetectionListener;
import amida.logmanager.PhaseScale;
import amida.logmanager.PhaseTableModel;
import amida.profiler.AgentConfigWindow;
import amida.viewer.ViewerWindow;
import java.io.File;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class PhaseWindow {
    private static final String[] PHASEFILE_EXTENSION = new String[]{"*.amd", "*"};
    private static final String[] LOGFILE_EXTENSION = new String[]{"*.log", "*"};

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Amida Phase View");
        shell.setLayout((Layout)new FillLayout());
        SashForm sash = new SashForm((Composite)shell, 512);
        Table table = new Table((Composite)sash, 2050);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 24;
            }
        });
        Text text = new Text((Composite)sash, 2882);
        sash.setWeights(new int[]{4, 1});
        Logger.getInstance().setOutput(text);
        PhaseTableModel model = new PhaseTableModel();
        TableManager.associate(table, model);
        PhaseWindow.createMenu(shell, model);
        shell.pack();
        shell.setSize(640, 400);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createMenu(final Shell shell, final PhaseTableModel model) {
        Menu menubar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menubar);
        MenuItem mnuFile = new MenuItem(menubar, 64);
        mnuFile.setText("File");
        Menu menu1 = new Menu(mnuFile);
        mnuFile.setMenu(menu1);
        MenuItem mnuFileNew = new MenuItem(menu1, 8);
        mnuFileNew.setText("New Phase Detection (&N) ...");
        MenuItem mnuFileOpen = new MenuItem(menu1, 8);
        mnuFileOpen.setText("Open an Existing File (&O) ...\tCTRL+O");
        mnuFileOpen.setAccelerator(262223);
        new MenuItem(menu1, 2);
        MenuItem mnuFileProfile = new MenuItem(menu1, 8);
        mnuFileProfile.setText("Profile a Java program (&P) ...");
        MenuItem mnuFileOpenLog = new MenuItem(menu1, 8);
        mnuFileOpenLog.setText("Open a log file without phase detection (&R) ...");
        new MenuItem(menu1, 2);
        MenuItem mnuQuit = new MenuItem(menu1, 8);
        mnuQuit.setText("Quit (&X)");
        mnuFileNew.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private PhaseDetectionLauncherWindow window = null;

            public void widgetSelected(SelectionEvent e) {
                if (this.window == null) {
                    this.window = new PhaseDetectionLauncherWindow();
                }
                this.window.open(shell, new PhaseDetectionFinishedAction(model));
            }
        });
        mnuFileOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private boolean isFirst = true;

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dialog = new FileDialog(shell, 4096);
                if (this.isFirst) {
                    dialog.setFilterPath(AmidaProperty.getInstance().getLogDir());
                    this.isFirst = false;
                }
                dialog.setFilterExtensions(PHASEFILE_EXTENSION);
                String s = dialog.open();
                if (s != null) {
                    File f = new File(s);
                    model.load(f);
                }
            }
        });
        mnuFileProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentConfigWindow.open(shell);
            }
        });
        mnuFileOpenLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dialog = new FileDialog(shell, 4096);
                dialog.setFilterExtensions(LOGFILE_EXTENSION);
                String s = dialog.open();
                if (s != null) {
                    File f = new File(s);
                    ViewerWindow.open(shell, new LogFileName(f.getAbsolutePath()));
                }
            }
        });
        mnuQuit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                shell.close();
            }
        });
        MenuItem mnuScale = new MenuItem(menubar, 64);
        mnuScale.setText("Scale");
        Menu menScaleChildren = new Menu(mnuScale);
        mnuScale.setMenu(menScaleChildren);
        MenuItem mnuScaleNormal = new MenuItem(menScaleChildren, 16);
        mnuScaleNormal.setText("Normal (&N)\tCTRL+1");
        mnuScaleNormal.setAccelerator(262193);
        mnuScaleNormal.addSelectionListener((SelectionListener)new ScaleChangeAction(model, PhaseScale.PHASE_SCALE_OPTION.NORMAL));
        mnuScaleNormal.setSelection(true);
        MenuItem mnuScaleSqrt = new MenuItem(menScaleChildren, 16);
        mnuScaleSqrt.setText("Square Root (&S)\tCTRL+2");
        mnuScaleSqrt.addSelectionListener((SelectionListener)new ScaleChangeAction(model, PhaseScale.PHASE_SCALE_OPTION.SQRT));
        mnuScaleSqrt.setAccelerator(262194);
        MenuItem mnuScaleLogscale = new MenuItem(menScaleChildren, 16);
        mnuScaleLogscale.setText("Logscale (&L)\tCTRL+3");
        mnuScaleLogscale.addSelectionListener((SelectionListener)new ScaleChangeAction(model, PhaseScale.PHASE_SCALE_OPTION.LOGSCALE));
        mnuScaleLogscale.setAccelerator(262195);
    }

    private static class PhaseDetectionFinishedAction
    implements PhaseDetectionListener {
        private PhaseTableModel model;

        public PhaseDetectionFinishedAction(PhaseTableModel model) {
            this.model = model;
        }

        @Override
        public void onFinished(Shell sender, boolean success, String targetFilename) {
            File f;
            if (success && (f = new File(String.valueOf(targetFilename) + ".amd")).canRead()) {
                if (!sender.isDisposed()) {
                    sender.close();
                }
                this.model.load(f);
            }
        }
    }

    private static class ScaleChangeAction
    implements SelectionListener {
        private PhaseTableModel model;
        private PhaseScale.PHASE_SCALE_OPTION option;

        public ScaleChangeAction(PhaseTableModel model, PhaseScale.PHASE_SCALE_OPTION option) {
            this.model = model;
            this.option = option;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            this.model.setPhaseScaleOption(this.option);
        }
    }
}

