/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.viewer.elements.SequenceObject;
import java.util.Comparator;

public class SequenceObjectSorter {
    public static final int COMPARE_APPEARANCE = 0;
    public static final int COMPARE_ID = 1;
    public static final int COMPARE_PACKAGE_NAME = 2;
    public static final int COMPARE_CLASS_NAME = 3;

    public static Comparator<SequenceObject> getSorter(int kind) {
        switch (kind) {
            case 0: {
                return new AppearanceIndexComparator();
            }
            case 1: {
                return new FirstIdComparator();
            }
            case 2: {
                return new PackageClassNameComparator();
            }
            case 3: {
                return new ClassNameComparator();
            }
        }
        return new AppearanceIndexComparator();
    }

    public static class AppearanceIndexComparator
    implements Comparator<SequenceObject> {
        @Override
        public int compare(SequenceObject o1, SequenceObject o2) {
            int id1 = o1.getAppearanceNum();
            int id2 = o2.getAppearanceNum();
            return id1 - id2;
        }
    }

    public static class ClassNameComparator
    implements Comparator<SequenceObject> {
        @Override
        public int compare(SequenceObject o1, SequenceObject o2) {
            return o1.getClassName().compareTo(o2.getClassName());
        }
    }

    public static class FirstIdComparator
    implements Comparator<SequenceObject> {
        @Override
        public int compare(SequenceObject o1, SequenceObject o2) {
            int id1 = o1.getIdList()[0];
            int id2 = o2.getIdList()[0];
            return id1 - id2;
        }
    }

    public static class PackageClassNameComparator
    implements Comparator<SequenceObject> {
        private PackageNameComparator packageComparator = new PackageNameComparator();
        private ClassNameComparator classComparator = new ClassNameComparator();

        @Override
        public int compare(SequenceObject o1, SequenceObject o2) {
            int packageResult = this.packageComparator.compare(o1, o2);
            if (packageResult != 0) {
                return packageResult;
            }
            return this.classComparator.compare(o1, o2);
        }
    }

    public static class PackageNameComparator
    implements Comparator<SequenceObject> {
        @Override
        public int compare(SequenceObject o1, SequenceObject o2) {
            return o1.getNameSpace().compareTo(o2.getNameSpace());
        }
    }
}

