/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.elements.Sequence;
import amida.viewer.elements.SequenceObject;
import amida.viewer.filter.DominanceFilter;
import amida.viewer.filter.MethodFilter;
import amida.viewer.filter.ObjectFilter;
import amida.viewer.filter.ObjectUnificationFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterSet {
    private List<ObjectFilter> objectFilters = new ArrayList<ObjectFilter>();
    private List<ObjectUnificationFilter> unificationFilters = new ArrayList<ObjectUnificationFilter>();
    private List<MethodFilter> methodFilters = new ArrayList<MethodFilter>();
    private DominanceFilter dominanceFilter;
    private FilterSet parent = null;

    public void setParentFilter(FilterSet parent) {
        this.parent = parent;
    }

    public FilterSet copy() {
        FilterSet clone = new FilterSet();
        clone.setParentFilter(this.parent);
        for (ObjectFilter objectFilter : this.objectFilters) {
            clone.addObjectFilter(objectFilter.copy());
        }
        for (ObjectUnificationFilter objectUnificationFilter : this.unificationFilters) {
            clone.addObjectUnificationFilter(objectUnificationFilter.copy());
        }
        for (MethodFilter methodFilter : this.methodFilters) {
            clone.addMethodFilter(methodFilter.copy());
        }
        return clone;
    }

    public void clear() {
        this.objectFilters.clear();
        this.unificationFilters.clear();
        this.methodFilters.clear();
    }

    public void insertHeadObjectFilter(ObjectFilter f) {
        this.objectFilters.add(0, f);
    }

    public void insertHeadUnificationFilter(ObjectUnificationFilter f) {
        this.unificationFilters.add(0, f);
    }

    public void addObjectFilter(ObjectFilter f) {
        this.objectFilters.add(f);
    }

    public void removeObjectFilter(ObjectFilter f) {
        this.objectFilters.remove(f);
    }

    public Iterable<ObjectFilter> objectFilters() {
        return this.objectFilters;
    }

    public Iterable<ObjectUnificationFilter> objectUnificationFilters() {
        return this.unificationFilters;
    }

    public void addObjectUnificationFilter(ObjectUnificationFilter f) {
        this.unificationFilters.add(f);
    }

    public void removeObjectUnificationFilter(ObjectUnificationFilter f) {
        this.unificationFilters.remove(f);
    }

    public void addMethodFilter(MethodFilter f) {
        this.methodFilters.add(f);
    }

    public void insertHeadMethodFilter(MethodFilter f) {
        this.methodFilters.add(0, f);
    }

    public void removeMethodFilter(MethodFilter f) {
        this.methodFilters.remove(f);
    }

    public Iterable<MethodFilter> methodFilters() {
        return this.methodFilters;
    }

    public void applyObjectFilters(SequenceObject seq) {
        for (ObjectFilter filter : this.objectFilters) {
            if (!filter.match(seq)) continue;
            seq.setVisibleState(filter.getVisibleState());
            return;
        }
        if (this.parent != null) {
            this.parent.applyObjectFilters(seq);
        }
    }

    public List<Collection<SequenceObject>> applyObjectUnificationFilters(List<SequenceObject> seq) {
        List<Object> groups = this.dominanceFilter != null ? this.dominanceFilter.apply(seq) : new ArrayList();
        for (ObjectUnificationFilter filter : this.unificationFilters) {
            Collection<SequenceObject> group = filter.match(seq);
            if (group.size() <= 1) continue;
            groups.add(group);
        }
        if (this.parent != null) {
            groups.addAll(this.parent.applyObjectUnificationFilters(seq));
        }
        return groups;
    }

    public int applyMethodFilters(Sequence seq) {
        for (MethodFilter filter : this.methodFilters) {
            if (!filter.match(seq)) continue;
            return filter.getVisibleState();
        }
        if (this.parent != null) {
            return this.parent.applyMethodFilters(seq);
        }
        return 0;
    }

    public void setDominanceFilter(DominanceFilter filter) {
        this.dominanceFilter = filter;
    }

    public DominanceFilter getDominanceFilter() {
        return this.dominanceFilter;
    }
}

