/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallTree;
import amida.calltree.Node;
import amida.log.MethodData;
import amida.log.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CallNode
extends Node {
    public static final int NOT_EXIT = 0;
    public static final int EXIT_NORMAL = 1;
    public static final int EXIT_EXCEPTION = 2;
    private List<CallNode> recursivePoints = new LinkedList<CallNode>();
    private boolean isRecursive = false;
    private boolean isBranch = false;
    private int exitMode;
    private final MethodData method;
    private int firstID;
    private int staticCallID;
    private Set<Integer> id = new TreeSet<Integer>();
    private String exception = null;
    private int callIndex;

    public CallNode(CallTree tree, MethodData method, int objectID, int index) {
        super(tree);
        this.callIndex = index;
        this.method = method;
        this.firstID = objectID;
        this.id.add(new Integer(objectID));
        this.staticCallID = 0;
    }

    public CallNode(CallTree tree, MethodData method, Set<Integer> ids, int index) {
        super(tree);
        this.callIndex = index;
        this.method = method;
        this.firstID = ids.iterator().next();
        this.id.addAll(ids);
        this.staticCallID = 0;
    }

    public int getFirstID() {
        return this.firstID;
    }

    public int getObjectGraphNodeID() {
        if (this.firstID != 0) {
            return this.firstID;
        }
        return this.staticCallID;
    }

    public void setStaticCallID(int value) {
        this.staticCallID = value;
    }

    public MethodData getMethod() {
        return this.method;
    }

    public String getClassName() {
        return this.getMethod().getBelongClass().getName();
    }

    public String getFullClassName() {
        return this.getMethod().getBelongClass().getFullName();
    }

    public String getPackageName() {
        return this.getMethod().getBelongClass().getNameSpace();
    }

    public String getNameSpace() {
        return this.getMethod().getBelongClass().getNameSpace();
    }

    private void setId(Set<Integer> id) {
        this.id = id;
    }

    public void addId(int id) {
        this.id.add(new Integer(id));
    }

    public void addId(Set<Integer> id) {
        for (Integer i : id) {
            this.id.add(i);
        }
    }

    public String getMethodName() {
        return this.getMethod().getName();
    }

    public Set<Integer> getId() {
        return this.id;
    }

    public Type[] getArgmentTypes() {
        return this.getMethod().getArgmentTypes();
    }

    public String[] getSimpleArgmentTypeNames() {
        Type[] types = this.getMethod().getArgmentTypes();
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            names[i] = types[i].getSimpleTypeName();
            ++i;
        }
        return names;
    }

    public String[] getArgmentTypeNames() {
        Type[] types = this.getMethod().getArgmentTypes();
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            names[i] = types[i].getTypeName();
            ++i;
        }
        return names;
    }

    public int getArgc() {
        return this.getMethod().getArgmentTypes().length;
    }

    public String getReturnTypeName() {
        return this.getMethod().getReturnType().getTypeName();
    }

    @Override
    public int getCallNodeNum() {
        return 1;
    }

    @Override
    public CallNode getCallNode(int i) {
        return this;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CallNode copy = (CallNode)super.clone();
        TreeSet<Integer> newId = new TreeSet<Integer>();
        newId.addAll(this.getId());
        copy.setId(newId);
        return copy;
    }

    public void addRecursivePoint(CallNode node) {
        this.recursivePoints.add(node);
    }

    public List<CallNode> getRecursivePoints() {
        return this.recursivePoints;
    }

    public void setRecursive(boolean bool) {
        this.isRecursive = bool;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public void setBranch(boolean bool) {
        this.isBranch = bool;
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int depth) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < depth) {
            buffer.append("\t");
            ++i;
        }
        buffer.append(String.valueOf(this.getStartString()) + lineSeparator);
        if (this.hasChildren()) {
            Iterator<Node> it = this.getChildren().iterator();
            while (it.hasNext()) {
                buffer.append(String.valueOf(it.next().toString(depth + 1)) + lineSeparator);
            }
        }
        i = 0;
        while (i < depth) {
            buffer.append("\t");
            ++i;
        }
        buffer.append(this.getEndString());
        return buffer.toString();
    }

    public String getStartString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isBranch) {
            buffer.append("? ");
        }
        if (this.isRecursive) {
            buffer.append("Recursive ");
        }
        buffer.append(String.valueOf(this.getReturnTypeName()) + " ");
        if (!this.getPackageName().equals("")) {
            buffer.append(String.valueOf(this.getPackageName()) + ".");
        }
        Iterator<Integer> it = this.id.iterator();
        if (this.id.size() == 1) {
            buffer.append(String.valueOf(this.getClassName()) + "(" + it.next() + ")." + this.getMethodName() + "(");
        } else {
            buffer.append(String.valueOf(this.getClassName()) + "( * )." + this.getMethodName() + "(");
        }
        Type[] args = this.getArgmentTypes();
        int i = 0;
        while (i < args.length) {
            buffer.append(String.valueOf(args[i].getTypeName()) + ",");
            ++i;
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append("){");
        return buffer.toString();
    }

    public String getEndString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("}");
        if (this.getExceptionName() != null) {
            buffer.append("(");
            buffer.append(this.getExceptionName());
            buffer.append(")");
        }
        return buffer.toString();
    }

    public boolean isConstructor() {
        return this.getMethod().isConstructor();
    }

    public int getDefaultLogSize() {
        return 2;
    }

    @Override
    public Node getNewInstance() {
        CallNode node = new CallNode(this.getCallTree(), this.getMethod(), this.getId(), this.callIndex);
        node.setExitMode(this.getExitMode());
        return node;
    }

    public int getCallIndex() {
        return this.callIndex;
    }

    public boolean isEnded() {
        return this.getExitMode() != 0;
    }

    /*
     * Unable to fully structure code
     */
    public CallNode getCallParent() {
        parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof CallNode)) ** GOTO lbl8
        return (CallNode)parent;
lbl-1000:
        // 1 sources

        {
            if (!(parent instanceof CallNode)) continue;
            return (CallNode)parent;
lbl8:
            // 2 sources

            ** while ((parent = parent.getParent()) != null)
        }
lbl9:
        // 1 sources

        return null;
    }

    public int getExitMode() {
        return this.exitMode;
    }

    public void setExitMode(int exitMode) {
        this.exitMode = exitMode;
    }

    public String getExceptionName() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }
}

