/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.ObjectGraph;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class DominanceTree {
    private TIntIntHashMap reversePostOrder;
    private TIntIntHashMap immediateDominator;

    public DominanceTree(ObjectGraph graph) {
        this.computeSpanningTree(graph);
        this.computeDominators(graph);
    }

    public int[] getNodes() {
        return this.reversePostOrder.keys();
    }

    public int getDominator(int objectID) {
        return this.immediateDominator.get(objectID);
    }

    private void computeSpanningTree(ObjectGraph graph) {
        boolean ROOT = false;
        boolean ON_STACK = true;
        int VISITED = 2;
        int counter = -1;
        this.reversePostOrder = new TIntIntHashMap();
        this.immediateDominator = new TIntIntHashMap();
        TIntStack stack = new TIntStack();
        stack.push(0);
        this.reversePostOrder.put(0, 1);
        while (stack.size() > 0) {
            int node = stack.peek();
            if (!this.reversePostOrder.containsKey(node) || this.reversePostOrder.get(node) == 1) {
                this.reversePostOrder.put(node, 2);
                int[] callees = graph.getSucc(node);
                int i = 0;
                while (i < callees.length) {
                    if (!this.reversePostOrder.containsKey(callees[i])) {
                        this.immediateDominator.put(callees[i], node);
                        this.reversePostOrder.put(callees[i], 1);
                        stack.push(callees[i]);
                    }
                    ++i;
                }
                continue;
            }
            assert (this.reversePostOrder.get(node) == 2);
            stack.pop();
            this.reversePostOrder.put(node, counter);
            --counter;
        }
    }

    private void computeDominators(ObjectGraph graph) {
        ArrayList<Integer> vertices = new ArrayList<Integer>(this.reversePostOrder.size());
        int[] keys = this.reversePostOrder.keys();
        int i = 0;
        while (i < keys.length) {
            vertices.add(new Integer(keys[i]));
            ++i;
        }
        Collections.sort(vertices, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                int i0 = DominanceTree.this.reversePostOrder.get(arg0.intValue());
                int i1 = DominanceTree.this.reversePostOrder.get(arg1.intValue());
                return i1 - i0;
            }
        });
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator vIt = vertices.iterator();
            while (vIt.hasNext()) {
                int v = (Integer)vIt.next();
                int[] pred = graph.getPred(v);
                int idx = 0;
                while (idx < pred.length) {
                    int nca;
                    int idom = this.immediateDominator.get(v);
                    if (idom != (nca = this.nearestCommonAncestor(idom, pred[idx]))) {
                        changed = true;
                        this.immediateDominator.put(v, nca);
                    }
                    ++idx;
                }
            }
        }
    }

    public int nearestCommonAncestor(int v1, int v2) {
        while (v1 != v2) {
            int i2;
            int i1 = this.reversePostOrder.get(v1);
            if (i1 > (i2 = this.reversePostOrder.get(v2))) {
                v1 = this.immediateDominator.get(v1);
                continue;
            }
            if (i1 >= i2) continue;
            v2 = this.immediateDominator.get(v2);
        }
        return v1;
    }
}

