/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;

public class ObjectGraph {
    private int staticObjectCount = 0;
    private TIntObjectHashMap<TIntHashSet> edges = new TIntObjectHashMap();
    private TIntObjectHashMap<TIntHashSet> reverse = new TIntObjectHashMap();

    public int getNewStaticCallID() {
        return -(++this.staticObjectCount);
    }

    public void addEdge(int callerID, int calleeID) {
        assert (callerID != 0);
        assert (calleeID != 0);
        TIntHashSet callees = (TIntHashSet)this.edges.get(callerID);
        if (callees == null) {
            callees = new TIntHashSet();
            this.edges.put(callerID, (Object)callees);
        }
        callees.add(calleeID);
        TIntHashSet callers = (TIntHashSet)this.reverse.get(calleeID);
        if (callers == null) {
            callers = new TIntHashSet();
            this.reverse.put(calleeID, (Object)callers);
        }
        callers.add(callerID);
    }

    public int[] getAllNodes() {
        TIntHashSet set = new TIntHashSet();
        set.addAll(this.edges.keys());
        set.addAll(this.reverse.keys());
        return set.toArray();
    }

    public int[] getPred(int callee) {
        if (callee == 0 || !this.reverse.containsKey(callee)) {
            return new int[0];
        }
        return ((TIntHashSet)this.reverse.get(callee)).toArray();
    }

    public int[] getSucc(int caller) {
        if (caller == 0) {
            TIntArrayList list = new TIntArrayList();
            int[] callers = this.edges.keys();
            int i = 0;
            while (i < callers.length) {
                if (!this.reverse.containsKey(callers[i])) {
                    list.add(callers[i]);
                }
                ++i;
            }
            return list.toNativeArray();
        }
        if (this.edges.containsKey(caller)) {
            return ((TIntHashSet)this.edges.get(caller)).toArray();
        }
        return new int[0];
    }
}

