/*
 * Decompiled with CFR 0.152.
 */
package amida.gui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public abstract class ProcessMonitorTask
implements Runnable {
    private Display display;
    private Text execLog;
    private Process process;
    private boolean finished;

    public ProcessMonitorTask(Display display, Text execLog, Process process) {
        this.display = display;
        this.process = process;
        this.execLog = execLog;
    }

    protected boolean checkAsyncExec(Runnable r) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(r);
            return true;
        }
        return false;
    }

    protected void outputText(final String output) {
        this.checkAsyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProcessMonitorTask.this.execLog.isDisposed()) {
                    ProcessMonitorTask.this.execLog.append(output);
                }
            }
        });
    }

    public void terminate() {
        this.process.destroy();
    }

    protected abstract void onFinished();

    protected abstract void onReadLine(String var1);

    @Override
    public void run() {
        Thread stdout = new Thread(new StreamReader(this.process.getInputStream()));
        Thread stderr = new Thread(new StreamReader(this.process.getErrorStream()));
        stdout.start();
        stderr.start();
        try {
            stdout.join();
            stderr.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finished = true;
        this.onFinished();
    }

    public boolean isFinished() {
        return this.finished;
    }

    private class StreamReader
    implements Runnable {
        private InputStream stream;

        public StreamReader(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.stream));
            StringBuilder builder = new StringBuilder();
            long time = System.currentTimeMillis();
            long PERIOD = 1000L;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    ProcessMonitorTask.this.onReadLine(line);
                    builder.append(line);
                    builder.append("\n");
                    if (time + PERIOD >= System.currentTimeMillis()) continue;
                    time = System.currentTimeMillis();
                    ProcessMonitorTask.this.outputText(builder.toString());
                    builder = new StringBuilder();
                }
                ProcessMonitorTask.this.outputText(builder.toString());
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

