/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.logmanager.CommandBuilder;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ParameterTable {
    public static final String[][] OPTIONS = new String[][]{{"Cache Size", "-c", "-C", "-d"}, {"Window Size", "-w", "-W", "-v"}, {"Threshold", "-t", "-T", "-u"}, {"Scope Size", "-s", "-S", "-r"}};
    private Shell shell;
    private Button execButton;
    private Table table;
    private TableCursor cursor;
    private ControlEditor editor;
    private String[][] param;

    public ParameterTable(Shell shell, Button execButton, String[][] param) {
        this.shell = shell;
        this.execButton = execButton;
        this.param = param;
        this.createTableWidget();
    }

    public Table getTableWidget() {
        return this.table;
    }

    private void createTableWidget() {
        this.table = new Table((Composite)this.shell, 34816);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = event.gc.getFontMetrics().getHeight() * 2;
                int height = ((ParameterTable)ParameterTable.this).table.computeSize((int)-1, (int)-1).y;
                Point currentSize = ParameterTable.this.table.getSize();
                if (height != currentSize.y) {
                    ParameterTable.this.table.setSize(currentSize.x, height);
                    ParameterTable.this.shell.layout();
                    ParameterTable.this.cursor.setSelection(0, 1);
                }
            }
        });
        this.cursor = new TableCursor(this.table, 0);
        this.editor = new ControlEditor((Composite)this.cursor);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (ParameterTable.this.cursor.getColumn() != 0) {
                    ParameterTable.this.openTextForTableEdit();
                }
            }
        });
        this.cursor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    e.doit = false;
                    ParameterTable.this.execButton.setFocus();
                }
            }
        });
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParameterTable.this.table.setSelection(new TableItem[]{ParameterTable.this.cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (ParameterTable.this.cursor.getColumn() != 0) {
                    ParameterTable.this.openTextForTableEdit();
                }
            }
        });
        TableColumn col1 = new TableColumn(this.table, 16384);
        col1.setText("Parameter");
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(this.table, 131072);
        col2.setText("from");
        col2.setWidth(60);
        TableColumn col3 = new TableColumn(this.table, 131072);
        col3.setText("to");
        col3.setWidth(60);
        TableColumn col4 = new TableColumn(this.table, 131072);
        col4.setText("step");
        col4.setWidth(60);
        int i = 0;
        while (i < OPTIONS.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(this.param[i]);
            ++i;
        }
    }

    private void openTextForTableEdit() {
        final Text text = new Text((Composite)this.cursor, 0);
        text.setText(this.cursor.getRow().getText(this.cursor.getColumn()));
        text.setFocus();
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    ParameterTable.this.cursor.getRow().setText(ParameterTable.this.cursor.getColumn(), text.getText());
                    text.dispose();
                    e.doit = false;
                    int col = ParameterTable.this.cursor.getColumn();
                    int row = ParameterTable.this.table.indexOf(ParameterTable.this.cursor.getRow());
                    if ((e.stateMask & 0x20000) == 0) {
                        if (col < ParameterTable.this.table.getColumnCount() - 1) {
                            ParameterTable.this.cursor.setSelection(row, ParameterTable.this.cursor.getColumn() + 1);
                            ParameterTable.this.openTextForTableEdit();
                        } else if (row < ParameterTable.this.table.getItemCount() - 1) {
                            ParameterTable.this.cursor.setSelection(row + 1, 1);
                            ParameterTable.this.openTextForTableEdit();
                        } else {
                            ParameterTable.this.execButton.setFocus();
                        }
                    } else if (col > 1) {
                        ParameterTable.this.cursor.setSelection(row, ParameterTable.this.cursor.getColumn() - 1);
                        ParameterTable.this.openTextForTableEdit();
                    } else if (row > 0) {
                        ParameterTable.this.cursor.setSelection(row - 1, ParameterTable.this.table.getColumnCount() - 1);
                        ParameterTable.this.openTextForTableEdit();
                    } else {
                        ParameterTable.this.execButton.setFocus();
                    }
                }
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.keyCode) {
                    case 13: {
                        ParameterTable.this.cursor.getRow().setText(ParameterTable.this.cursor.getColumn(), text.getText());
                    }
                    case 27: {
                        text.dispose();
                    }
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ParameterTable.this.cursor.getRow().setText(ParameterTable.this.cursor.getColumn(), text.getText());
                text.dispose();
            }
        });
        this.editor.setEditor((Control)text);
    }

    public String getParameterOption() {
        CommandBuilder cmd = new CommandBuilder();
        int row = 0;
        while (row < this.table.getItemCount()) {
            TableItem item = this.table.getItem(row);
            int col = 1;
            while (col < this.table.getColumnCount()) {
                cmd.append(OPTIONS[row][col]);
                cmd.append(item.getText(col));
                ++col;
            }
            ++row;
        }
        return cmd.toString();
    }
}

