/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.logmanager.AmidaProperty;
import amida.logmanager.ExternalPhaseDetection;
import amida.logmanager.FileFilters;
import amida.logmanager.ParameterTable;
import amida.logmanager.PhaseDetectionListener;
import amida.phase.ILogger;
import amida.phase.IPhaseDetectionTask;
import amida.phase.IPhaseDetectionTaskListener;
import amida.phase.Parameter;
import amida.phase.PhaseDetection;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class PhaseDetectionLauncherWindow {
    public static final String CAPTION_EXECUTE = "Execute!";
    public static final String CAPTION_CANCEL = "CANCEL";
    private String filename = String.valueOf(AmidaProperty.getInstance().getLogDir()) + File.separator + AmidaProperty.getInstance().getDefaultLogFilename();
    private String[][] parameters = new String[4][];
    private Shell shell;
    private Text logFileText;
    private static IPhaseDetectionTask currentTask = null;

    public static void main(String[] args) {
        Display display = new Display();
        PhaseDetectionLauncherWindow window = new PhaseDetectionLauncherWindow();
        window.shell = new Shell(display);
        window.constructWindow(null);
        window.shell.open();
        while (!window.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public PhaseDetectionLauncherWindow() {
        int i = 0;
        while (i < ParameterTable.OPTIONS.length) {
            this.parameters[i] = AmidaProperty.getInstance().getPhaseDetectionParam(i);
            ++i;
        }
    }

    public void open(Shell parent, PhaseDetectionListener listener) {
        assert (this.shell == null || this.shell.isDisposed());
        this.shell = new Shell(parent, 68656);
        this.constructWindow(listener);
        if (this.selectFile(parent)) {
            Point p = this.shell.computeSize(-1, -1);
            this.shell.setSize(parent.getSize().x, p.y + 100);
            this.shell.open();
        } else {
            this.shell.dispose();
            this.logFileText = null;
            this.shell = null;
        }
    }

    private boolean selectFile(Shell parent) {
        FileDialog dialog = new FileDialog(parent, 4096);
        File f = new File(this.logFileText.getText());
        dialog.setFileName(f.getAbsolutePath());
        dialog.setFilterNames(FileFilters.LOGFILE_DESCRIPTION);
        dialog.setFilterExtensions(FileFilters.LOGFILE_EXTENSION);
        String filename = dialog.open();
        if (filename != null) {
            this.logFileText.setText(filename);
        }
        return filename != null;
    }

    private void constructWindow(final PhaseDetectionListener listener) {
        this.shell.setText("Phase Detection");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite composite1 = new Composite((Composite)this.shell, 0);
        GridData dataComposite = new GridData();
        dataComposite.grabExcessHorizontalSpace = true;
        dataComposite.horizontalAlignment = 4;
        composite1.setLayoutData((Object)dataComposite);
        this.logFileText = new Text(composite1, 2052);
        this.logFileText.setText(this.filename);
        Button browseBtn = new Button(composite1, 8);
        browseBtn.setText("...");
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhaseDetectionLauncherWindow.this.selectFile(PhaseDetectionLauncherWindow.this.shell);
            }
        });
        final Button execButton = new Button(composite1, 8);
        execButton.setText(CAPTION_EXECUTE);
        composite1.setLayout((Layout)new FormLayout());
        FormData formForText = new FormData();
        formForText.top = new FormAttachment(0, 0);
        formForText.left = new FormAttachment(0, 0);
        formForText.right = new FormAttachment((Control)browseBtn, 0);
        this.logFileText.setLayoutData((Object)formForText);
        FormData formForBrowse = new FormData();
        formForBrowse.top = new FormAttachment(0, 0);
        formForBrowse.right = new FormAttachment((Control)execButton, 0);
        browseBtn.setLayoutData((Object)formForBrowse);
        FormData formForExec = new FormData();
        formForExec.top = new FormAttachment(0, 0);
        formForExec.right = new FormAttachment(100, 0);
        execButton.setLayoutData((Object)formForExec);
        final ParameterTable table = new ParameterTable(this.shell, execButton, this.parameters);
        final Table parameterTable = table.getTableWidget();
        GridData tableData = new GridData();
        tableData.horizontalAlignment = 4;
        tableData.verticalAlignment = 4;
        parameterTable.setLayoutData((Object)tableData);
        final Text execLogText = new Text((Composite)this.shell, 2626);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        execLogText.setLayoutData((Object)data);
        execButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (currentTask == null || currentTask.isFinished()) {
                    if (AmidaProperty.getInstance().useExternalPhaseDetection()) {
                        currentTask = ExternalPhaseDetection.executePhaseDetection(PhaseDetectionLauncherWindow.this.shell, listener, PhaseDetectionLauncherWindow.this.logFileText.getText(), table, execLogText, execButton);
                    } else {
                        currentTask = PhaseDetectionLauncherWindow.this.callPhaseDetection(PhaseDetectionLauncherWindow.this.shell, listener, PhaseDetectionLauncherWindow.this.logFileText.getText(), table, new TextLogger(PhaseDetectionLauncherWindow.this.shell.getDisplay(), execLogText), execButton);
                    }
                } else {
                    PhaseDetectionLauncherWindow.askTerminate(PhaseDetectionLauncherWindow.this.shell);
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (currentTask != null && !currentTask.isFinished()) {
                    e.doit = PhaseDetectionLauncherWindow.askTerminate(PhaseDetectionLauncherWindow.this.shell);
                } else {
                    PhaseDetectionLauncherWindow.this.filename = PhaseDetectionLauncherWindow.this.logFileText.getText();
                    PhaseDetectionLauncherWindow.this.parameters = new String[ParameterTable.OPTIONS.length][];
                    int row = 0;
                    while (row < ParameterTable.OPTIONS.length) {
                        ((PhaseDetectionLauncherWindow)PhaseDetectionLauncherWindow.this).parameters[row] = new String[parameterTable.getColumnCount()];
                        int col = 0;
                        while (col < parameterTable.getColumnCount()) {
                            ((PhaseDetectionLauncherWindow)PhaseDetectionLauncherWindow.this).parameters[row][col] = parameterTable.getItem(row).getText(col);
                            ++col;
                        }
                        ++row;
                    }
                    e.doit = true;
                }
            }
        });
        this.shell.pack();
        this.shell.setSize(640, 400);
    }

    private static boolean askTerminate(Shell shell) {
        MessageBox box = new MessageBox(shell, 288);
        box.setText("Phase detection process is still running");
        box.setMessage("Are you sure to terminate the phase detection process?");
        if (box.open() == 32) {
            currentTask.terminate();
            return true;
        }
        return false;
    }

    private IPhaseDetectionTask callPhaseDetection(final Shell shell, final PhaseDetectionListener listener, final String logfile, ParameterTable parameters, final ILogger logger, final Button execButton) {
        String[] opt = parameters.getParameterOption().split("\\s+");
        String[] params = new String[opt.length + 1];
        int i = 0;
        while (i < opt.length) {
            params[i] = opt[i];
            ++i;
        }
        params[opt.length] = new File(logfile).getAbsolutePath();
        Parameter param = new Parameter(params);
        PhaseDetection detect = new PhaseDetection(param, new IPhaseDetectionTaskListener(){

            @Override
            public void finished(final boolean success) {
                if (!shell.isDisposed()) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!execButton.isDisposed()) {
                                execButton.setText(PhaseDetectionLauncherWindow.CAPTION_EXECUTE);
                                if (logger != null) {
                                    if (success) {
                                        logger.output("Completed.");
                                    } else {
                                        logger.output("Cancelled.");
                                    }
                                }
                                if (listener != null) {
                                    listener.onFinished(shell, success, new File(logfile).getAbsolutePath());
                                }
                            }
                        }
                    });
                }
            }
        }, logger);
        execButton.setText(CAPTION_CANCEL);
        detect.execute();
        return detect;
    }

    private class TextLogger
    implements ILogger {
        private Display display;
        private Text log;

        public TextLogger(Display display, Text log) {
            this.display = display;
            this.log = log;
        }

        @Override
        public void output(String line) {
            this.outputlog(line);
        }

        @Override
        public void error(String line) {
            this.outputlog(line);
        }

        private void outputlog(final String line) {
            if (!this.display.isDisposed()) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextLogger.this.log.isDisposed()) {
                            TextLogger.this.log.append(String.valueOf(line) + "\n");
                        }
                    }
                });
            }
        }
    }
}

