/*
 * Decompiled with CFR 0.152.
 */
package amida.phase;

import amida.phase.BigDecimalIterator;
import java.math.BigDecimal;
import junit.framework.TestCase;

public class BigDecimalIteratorTest
extends TestCase {
    private static final BigDecimal THREE = new BigDecimal(3);
    private static final BigDecimal FIVE = new BigDecimal(5);
    private static final BigDecimal TEN = new BigDecimal(10);
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final BigDecimal ZERO_POINT_ONE = new BigDecimal("0.1");

    public void testFloatIterator() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, TEN, BigDecimal.ONE);
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(2.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(4.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(5.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(6.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(7.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(8.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(9.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(10.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithZeroIncrement() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, TEN, BigDecimal.ZERO);
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithMinusIncrement() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, TEN, BigDecimal.ONE.negate());
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithSmallIncrement() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, TEN, THREE);
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(6.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(9.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithIncrement() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, TEN, FIVE);
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(5.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(10.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithLargeIncrement() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, TEN, HUNDRED);
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithTheSameMinMax() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE);
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithSmallerMax() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ONE);
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }

    public void testFloatIteratorWithFloatValue() {
        BigDecimalIterator it = new BigDecimalIterator(BigDecimal.ZERO, BigDecimal.ONE, ZERO_POINT_ONE);
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.1f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.2f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.3f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.4f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.5f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.6f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.7f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.8f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(0.9f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertTrue((boolean)it.hasNext());
        BigDecimalIteratorTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(it.next()));
        BigDecimalIteratorTest.assertFalse((boolean)it.hasNext());
    }
}

