/*
 * Decompiled with CFR 0.152.
 */
package amida.phase;

import amida.log.LogEntry;
import amida.log.MethodCallEntry;
import amida.log.MethodExitEntry;
import amida.log.TextLogLineParser;
import amida.log.ThreadStartEntry;
import amida.log.java.JavaTypeManager;
import amida.phase.ActorFileReader;
import amida.phase.ActorFileWriter;
import amida.phase.BigDecimalIterator;
import amida.phase.CacheUpdateFrequencyReader;
import amida.phase.CacheUpdateFrequencyWriter;
import amida.phase.CacheUpdateRecord;
import amida.phase.Event;
import amida.phase.Filepath;
import amida.phase.ILogger;
import amida.phase.IPhaseDetectionTask;
import amida.phase.IPhaseDetectionTaskListener;
import amida.phase.IntIterator;
import amida.phase.LRUCache;
import amida.phase.ObjectIdMap;
import amida.phase.Parameter;
import amida.phase.PhaseFile;
import gnu.trove.TIntStack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Stack;

public class PhaseDetection
implements IPhaseDetectionTask {
    private Parameter param;
    private Filepath filepath;
    private PhaseFile outputFile;
    private Thread thread;
    private boolean terminated;
    private IPhaseDetectionTaskListener listener;
    private ILogger logger;

    public PhaseDetection(Parameter param, IPhaseDetectionTaskListener listener, ILogger logger) {
        this.param = param;
        this.filepath = null;
        this.outputFile = null;
        this.listener = listener;
        this.logger = logger;
    }

    @Override
    public boolean isFinished() {
        return this.terminated;
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }

    public void execute() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                PhaseDetection.this.detectPhases();
                boolean success = !PhaseDetection.this.terminated;
                PhaseDetection.this.terminated = true;
                if (PhaseDetection.this.listener != null) {
                    PhaseDetection.this.listener.finished(success);
                }
            }
        });
        this.thread.start();
    }

    public static void main(String[] args) {
        Parameter param = new Parameter(args);
        new PhaseDetection(param, null, new SystemPrinter()).execute();
    }

    /*
     * Unable to fully structure code
     */
    private void detectPhases() {
        block3: {
            block4: {
                try {
                    this.filepath = new Filepath(this.param.getFilename());
                    this.logger.output("Creating annotated log file: " + this.filepath.getAnnotatedLogFile().getAbsolutePath());
                    this.logToSeplog();
                    this.logger.output("Creating actor data");
                    this.outputFile = this.logToActor('o');
                    this.outputFile.open(this.filepath);
                    this.toCsvData();
                    this.outputFile.close();
                    this.filepath.deleteTemporaryFiles();
                    break block3;
                }
                catch (IOException e) {
                    this.logger.error("Failed to detect phases.");
                    this.logger.error(e.getLocalizedMessage());
                    stack = e.getStackTrace();
                    if (stack == null) break block4;
                    i = 0;
                    ** while (i < stack.length)
                }
lbl-1000:
                // 1 sources

                {
                    this.logger.error(stack[i].toString());
                    ++i;
                    continue;
                }
            }
            this.outputFile = null;
        }
    }

    private void logToSeplog() throws IOException {
        String ln;
        Stack<String> callstack = new Stack<String>();
        callstack.push("-1");
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(this.filepath.getAnnotatedLogFile())));
        PrintWriter pwThread = new PrintWriter(new FileWriter(this.filepath.getThreadFile()));
        BufferedReader br = new BufferedReader(new FileReader(this.filepath.getOriginalLogFile()));
        while ((ln = br.readLine()) != null) {
            if ((ln = ln.replace(System.getProperty("line.separator"), "")).startsWith("@thread")) {
                pwThread.println(ln);
                continue;
            }
            if (ln.indexOf("{") != -1) {
                callstack.push(ln.replace("{", ""));
            } else if (ln.indexOf("}") != -1) {
                callstack.pop();
                ln = String.valueOf(ln) + " returnTo: " + (String)callstack.peek();
            }
            pw.println(ln);
        }
        br.close();
        pwThread.close();
        pw.close();
    }

    private PhaseFile logToActor(char assignmentUnit) throws IOException {
        String ln;
        TIntStack callstack = new TIntStack();
        callstack.push(-1);
        ObjectIdMap objects = new ObjectIdMap();
        if (assignmentUnit == 'p') {
            objects.map("0");
        }
        int index = 0;
        int linecounter = 0;
        ActorFileWriter actorWriter = new ActorFileWriter(new FileOutputStream(this.filepath.getActorFile()));
        BufferedReader br = new BufferedReader(new FileReader(this.filepath.getAnnotatedLogFile()));
        long currentFilepointer = 0L;
        long accumulatedFilepointer = 0L;
        int breakBytes = System.getProperty("line.separator").getBytes().length;
        TextLogLineParser parser = new TextLogLineParser(new JavaTypeManager());
        while ((ln = br.readLine()) != null) {
            accumulatedFilepointer += (long)ln.getBytes().length + (long)breakBytes;
            LogEntry entry = parser.parseLine(ln);
            if (entry instanceof ThreadStartEntry) continue;
            if (entry instanceof MethodExitEntry) {
                callstack.pop();
                currentFilepointer = accumulatedFilepointer;
                continue;
            }
            if (!(entry instanceof MethodCallEntry)) continue;
            int id = 0;
            ++index;
            ++linecounter;
            MethodCallEntry call = (MethodCallEntry)entry;
            switch (assignmentUnit) {
                case 'm': {
                    id = objects.map(call.getMethod().toString());
                    break;
                }
                case 'c': {
                    id = objects.map(call.getFullClassName());
                    break;
                }
                case 'p': {
                    id = objects.map(call.getMethod().getBelongClass().getNameSpace());
                    break;
                }
                case 'o': {
                    objects.map(Integer.toString(call.getObjectId()));
                    id = call.getObjectId();
                    break;
                }
                default: {
                    throw new RuntimeException("This statement must not be executed. Unknown assignment unit: " + assignmentUnit);
                }
            }
            actorWriter.write(index, callstack.peek(), id, callstack.size(), currentFilepointer);
            callstack.push(id);
        }
        br.close();
        actorWriter.close();
        return new PhaseFile(objects.size(), linecounter);
    }

    private void ratioToPhase(int csize, int wsize, int windex, int scope, float threshold, Boolean thresholdAbbr) throws IOException {
        ArrayList<Event> phaseHead = new ArrayList<Event>();
        Event event = null;
        Event previous = null;
        CacheUpdateFrequencyReader reader = new CacheUpdateFrequencyReader(new FileInputStream(this.filepath.getCacheUpdateFrequency()));
        int deepest = 0;
        boolean first = true;
        boolean upflag = false;
        while (reader.readEvent()) {
            int numS;
            if (first) {
                event = reader.getCurrentEvent();
                phaseHead.add(reader.getCurrentEvent());
                deepest = 0;
                first = false;
                continue;
            }
            previous = event;
            event = reader.getCurrentEvent();
            if (upflag) {
                if (event.getFreq(windex) < previous.getFreq(windex)) {
                    upflag = false;
                    if ((thresholdAbbr == false && (double)threshold < event.getFreq(windex) || thresholdAbbr.booleanValue()) && reader.getEvent(deepest).getIndex() > phaseHead.get(phaseHead.size() - 1).getIndex()) {
                        phaseHead.add(reader.getEvent(deepest));
                    }
                }
            } else {
                boolean bl = upflag = event.getFreq(windex) > previous.getFreq(windex);
            }
            if ((numS = reader.getEventCount()) >= scope) {
                reader.removeOldestEvent();
                --deepest;
            }
            if (deepest == -1) {
                deepest = reader.findEventIndexOfMinimumStackDepth();
                continue;
            }
            if (numS == 1) {
                deepest = 0;
                continue;
            }
            if (reader.getEvent(deepest).getCallstackDepth() < event.getCallstackDepth() || event.getCallstackDepth() == previous.getCallstackDepth()) continue;
            deepest = reader.getEventCount() - 1;
        }
        reader.close();
        this.outputFile.put(csize, wsize, threshold, scope, phaseHead);
    }

    private void detectPhaseInner(int csize, float tsize) throws IOException {
        Boolean thresholdAbbr = false;
        IntIterator window = this.param.getWindowSizeIterator();
        while (window.hasNext()) {
            int wsize = window.next();
            int windex = window.getIndex();
            IntIterator it = this.param.getPhaseHeadDistanceIterator();
            while (it.hasNext()) {
                int ssize = it.next();
                this.ratioToPhase(csize, wsize, windex, ssize, tsize, thresholdAbbr);
                StringBuilder buf = new StringBuilder();
                buf.append("C").append(csize);
                buf.append(", W").append(wsize);
                buf.append(", T").append(tsize);
                buf.append(", M").append(ssize);
                buf.append(" (").append(this.param.progress()).append("%)");
                this.logger.output(buf.toString());
                if (!this.terminated) continue;
                return;
            }
        }
    }

    private void detectPhase(int csize) throws IOException {
        BigDecimalIterator it = this.param.getThresholdIterator();
        while (it.hasNext()) {
            float tsize = it.next();
            this.detectPhaseInner(csize, tsize);
            if (!this.terminated) continue;
            return;
        }
    }

    private void computeCacheUpdate(int cache_size) throws IOException {
        LRUCache cache = new LRUCache(cache_size);
        CacheUpdateRecord cacheUpdate = new CacheUpdateRecord(this.param.getMaxWindowSize());
        CacheUpdateFrequencyWriter writer = new CacheUpdateFrequencyWriter(new FileOutputStream(this.filepath.getCacheUpdateFrequency()));
        ActorFileReader reader = new ActorFileReader(new FileInputStream(this.filepath.getActorFile()));
        double[] freq = new double[this.param.getWindowSizeCount()];
        while (reader.readEvent()) {
            boolean callerUpdated = cache.update(reader.getCallerID());
            boolean calleeUpdated = cache.update(reader.getCalleeID());
            cacheUpdate.record(callerUpdated || calleeUpdated);
            int idx = 0;
            IntIterator it = this.param.getWindowSizeIterator();
            while (it.hasNext()) {
                int wsize = it.next();
                freq[idx] = cacheUpdate.getFrequency(wsize);
                ++idx;
            }
            writer.write(reader.getIndex(), reader.getCallstackDepth(), reader.getFilePointer(), freq);
        }
        writer.close();
        reader.close();
    }

    private void toCsvData() throws IOException {
        IntIterator it = this.param.getCacheSizeIterator();
        while (it.hasNext()) {
            int csize = it.next();
            this.computeCacheUpdate(csize);
            this.detectPhase(csize);
            if (!this.terminated) continue;
            return;
        }
    }

    private static class SystemPrinter
    implements ILogger {
        private SystemPrinter() {
        }

        @Override
        public void output(String line) {
            System.out.println(line);
        }

        @Override
        public void error(String line) {
            System.err.println(line);
        }
    }
}

