/*
 * Decompiled with CFR 0.152.
 */
package amida.phase;

import amida.phase.Event;
import amida.phase.Filepath;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class PhaseFile {
    static PrintWriter pw;
    private int objects;
    private int events;
    private static final String SEPARATOR = ", ";

    public PhaseFile(int objects, int events) {
        this.objects = objects;
        this.events = events;
    }

    public void open(Filepath filepath) {
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(filepath.getPhaseFile())));
            pw.println("<Amida>");
            pw.print("logfile=");
            pw.println(filepath.getAnnotatedLogFile().getName());
            pw.print("threadfile=");
            pw.println(filepath.getThreadFile().getName());
            pw.print("objects=");
            pw.println(this.objects);
            pw.print("events=");
            pw.println(this.events);
            pw.println("</Amida>");
            pw.println("#Cache, Window, Threshold, Scope, #events, #phases, beginning event of phase 1, filepinter of beginning of phase 1 , ... , beginning event of phase N, file pointer of beginning of phase N, ");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Failed to make " + filepath.getPhaseFile().getAbsolutePath());
        }
    }

    public int getEvents() {
        return this.events;
    }

    public void put(int csize, int wsize, float threshold, int scope, List<Event> phases) {
        StringBuilder buf = new StringBuilder();
        buf.append(csize);
        buf.append(SEPARATOR);
        buf.append(wsize);
        buf.append(SEPARATOR);
        buf.append(Float.toString(threshold));
        buf.append(SEPARATOR);
        buf.append(scope);
        buf.append(SEPARATOR);
        buf.append(this.getEvents());
        buf.append(SEPARATOR);
        buf.append(phases.size());
        buf.append(SEPARATOR);
        for (Event event : phases) {
            buf.append(event.getIndex());
            buf.append(SEPARATOR);
            buf.append(event.getFilePointer());
            buf.append(SEPARATOR);
        }
        pw.println(buf.toString());
    }

    public void close() {
        pw.close();
    }
}

