/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.viewer.SequenceDiagramDrawer;
import amida.viewer.SequenceDiagramModel;
import amida.viewer.ViewUpdater;
import amida.viewer.elements.Sequence;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Slider;

public class SequenceDiagramTab
implements MouseListener,
MouseMoveListener,
MouseWheelListener {
    private Composite diagram;
    private Composite objectComposite;
    private Composite overviewComposite;
    private SequenceDiagramModel model;
    private SequenceDiagramDrawer drawer;
    private Slider hDiagramSlider;
    private Slider vDiagramSlider;
    private ViewUpdater updater;
    private int dragX;
    private int dragY;
    private int baseHorizontalPos;
    private int baseVerticalPos;

    public SequenceDiagramTab(SequenceDiagramModel model, Composite diagram, Composite objectComposite, Composite overviewComposite, SequenceDiagramDrawer drawer, Slider hDiagramSlider, Slider vDiagramSlider, ViewUpdater updater) {
        this.diagram = diagram;
        this.model = model;
        this.objectComposite = objectComposite;
        this.overviewComposite = overviewComposite;
        this.drawer = drawer;
        this.hDiagramSlider = hDiagramSlider;
        this.vDiagramSlider = vDiagramSlider;
        this.updater = updater;
        this.diagram.addMouseListener((MouseListener)this);
        this.diagram.addMouseMoveListener((MouseMoveListener)this);
        this.diagram.addMouseWheelListener((MouseWheelListener)this);
        this.objectComposite.addMouseListener((MouseListener)new FocusSetter());
        this.overviewComposite.addMouseListener((MouseListener)new FocusSetter());
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.drawer.processDoubleClick(e.x, e.y, e.button);
    }

    public void mouseDown(MouseEvent e) {
        this.diagram.setFocus();
        this.drawer.selectElement(e.x, e.y, e.button);
        this.dragX = e.x;
        this.dragY = e.y;
        this.baseHorizontalPos = this.hDiagramSlider.getSelection();
        this.baseVerticalPos = this.vDiagramSlider.getSelection();
        this.diagram.setCapture(true);
    }

    public void mouseMove(MouseEvent e) {
        if ((e.stateMask & 0x80000) != 0) {
            int incX = this.dragX - e.x;
            int incY = this.dragY - e.y;
            this.hDiagramSlider.setSelection(this.baseHorizontalPos + incX);
            this.vDiagramSlider.setSelection(this.baseVerticalPos + incY);
            this.updater.fireRedraw();
        }
    }

    public void mouseScrolled(MouseEvent e) {
        int scroll = e.count;
        this.vDiagramSlider.setSelection(this.vDiagramSlider.getSelection() - scroll * this.vDiagramSlider.getIncrement());
        this.updater.fireRedraw();
    }

    public SequenceDiagramModel getModel() {
        return this.model;
    }

    private void showObject(int objIndex) {
        int x = this.drawer.getObjectPosition(objIndex);
        if ((x -= this.diagram.getSize().x / 2) < 0) {
            x = 0;
        }
        this.hDiagramSlider.setSelection(x);
    }

    public void selectAndShowObject(int objIndex) {
        this.showObject(objIndex);
        this.drawer.selectObjectByIndex(objIndex);
    }

    public void selectAndShowSequence(int seqIndex) {
        Sequence seq = this.model.getSequence(seqIndex);
        this.showObject(seq.getEndIndex());
        int y = this.drawer.getSequenceY(seqIndex);
        if ((y -= this.diagram.getSize().y / 2) < 0) {
            y = 0;
        }
        this.vDiagramSlider.setSelection(y);
        if (seq.getType() == 1 || seq.getType() == 5) {
            seqIndex = seq.getPareSequence().getIndex();
        }
        this.drawer.selectSequenceByIndex(seqIndex);
    }

    public void setFocus() {
        this.diagram.setFocus();
    }

    private class FocusSetter
    extends MouseAdapter {
        private FocusSetter() {
        }

        public void mouseDown(MouseEvent e) {
            SequenceDiagramTab.this.setFocus();
        }
    }
}

