/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.log.LogFileName;
import amida.logmanager.AmidaProperty;
import amida.viewer.ICompactionCommand;
import amida.viewer.IStatefulAmidaCommand;
import amida.viewer.SequenceDiagramTabView;
import java.io.File;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ViewerWindow {
    private Shell shell;
    private SequenceDiagramTabView diagramView;

    public static void main(String[] args) {
        Display display = new Display();
        ViewerWindow window = new ViewerWindow(display);
        window.shell.open();
        int i = 0;
        while (i < args.length) {
            File f;
            if (!args[i].startsWith("-") && (f = new File(args[i])).exists()) {
                window.loadFile(new LogFileName(f.getAbsolutePath()));
            }
            ++i;
        }
        while (!window.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void open(Shell parent, LogFileName file) {
        ViewerWindow window = new ViewerWindow(parent.getDisplay());
        window.shell.open();
        if (file != null) {
            window.loadFile(file);
        }
    }

    private ViewerWindow(Display display) {
        this.shell = new Shell(display);
        this.constructWindow();
    }

    private ViewerWindow(Shell parent) {
        this.shell = new Shell(parent, 66672);
        this.constructWindow();
    }

    public void loadFile(LogFileName file) {
        this.diagramView.loadFile(file);
    }

    public void constructWindow() {
        Composite client = new Composite((Composite)this.shell, 0);
        this.shell.setLayout((Layout)new FillLayout());
        this.diagramView = new SequenceDiagramTabView(client);
        this.constructMenu();
        this.shell.setText("Amida Viewer");
        this.shell.pack();
        this.shell.setSize(640, 400);
    }

    private void constructMenu() {
        Menu menubar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menubar);
        MenuItem mnuFile = new MenuItem(menubar, 64);
        mnuFile.setText("File(&F)");
        Menu menu1 = new Menu(mnuFile);
        mnuFile.setMenu(menu1);
        MenuItem mnuFileOpen = new MenuItem(menu1, 8);
        mnuFileOpen.setText("Open a log file (&O) ...\tCTRL+O");
        mnuFileOpen.setAccelerator(262223);
        new MenuItem(menu1, 2);
        MenuItem mnuQuit = new MenuItem(menu1, 8);
        mnuQuit.setText("Quit (&X)");
        mnuFileOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private boolean isFirst = true;

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dialog = new FileDialog(ViewerWindow.this.shell, 4096);
                if (this.isFirst) {
                    dialog.setFilterPath(AmidaProperty.getInstance().getLogDir());
                    this.isFirst = false;
                }
                dialog.setFilterExtensions(new String[]{"*.log", "*.*"});
                String s = dialog.open();
                if (s != null) {
                    ViewerWindow.this.loadFile(new LogFileName(s));
                }
            }
        });
        mnuQuit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.shell.close();
            }
        });
        MenuItem toolMenu = new MenuItem(menubar, 64);
        toolMenu.setText("Tool(&T)");
        Menu toolChildrenMenu = new Menu(toolMenu);
        toolMenu.setMenu(toolChildrenMenu);
        MenuItem mnuFindDialog = new MenuItem(toolChildrenMenu, 8);
        mnuFindDialog.setText("Search ... \tCTRL+F");
        mnuFindDialog.setAccelerator(262214);
        mnuFindDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.diagramView.openSearchDialog();
            }
        });
        MenuItem mnuFilterDialog = new MenuItem(toolChildrenMenu, 8);
        mnuFilterDialog.setText("Filters ...\tCTRL+E");
        mnuFilterDialog.setAccelerator(262213);
        mnuFilterDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.diagramView.openFilterDialog();
            }
        });
        MenuItem conpactionMenu = new MenuItem(toolChildrenMenu, 64);
        conpactionMenu.setText("Compaction");
        Menu menu2 = new Menu(conpactionMenu);
        conpactionMenu.setMenu(menu2);
        MenuItem mnuSimpleLoop = new MenuItem(menu2, 8);
        mnuSimpleLoop.setText("Simple Loop Detection");
        MenuItem mnuObjectLoop = new MenuItem(menu2, 8);
        mnuObjectLoop.setText("Object difference loop");
        MenuItem mnuMissingLoop = new MenuItem(menu2, 8);
        mnuMissingLoop.setText("Method missing loop");
        MenuItem mnuRecursiveLoop = new MenuItem(menu2, 8);
        mnuRecursiveLoop.setText("Recursive call detection");
        mnuSimpleLoop.addSelectionListener((SelectionListener)new CompactionMenu(1));
        mnuObjectLoop.addSelectionListener((SelectionListener)new CompactionMenu(2));
        mnuMissingLoop.addSelectionListener((SelectionListener)new CompactionMenu(3));
        mnuRecursiveLoop.addSelectionListener((SelectionListener)new CompactionMenu(4));
        MenuItem mnuSort = new MenuItem(toolChildrenMenu, 64);
        mnuSort.setText("Sort Objects");
        Menu mnuSortChildren = new Menu(mnuSort);
        mnuSort.setMenu(mnuSortChildren);
        MenuItem mnuSortNatural = new MenuItem(mnuSortChildren, 8);
        mnuSortNatural.setText("Timestamp");
        mnuSortNatural.addSelectionListener((SelectionListener)new ObjectSorter(0));
        MenuItem mnuSortID = new MenuItem(mnuSortChildren, 8);
        mnuSortID.setText("Object ID");
        mnuSortID.addSelectionListener((SelectionListener)new ObjectSorter(1));
        MenuItem mnuSortPackage = new MenuItem(mnuSortChildren, 8);
        mnuSortPackage.setText("Package Name");
        mnuSortPackage.addSelectionListener((SelectionListener)new ObjectSorter(2));
        MenuItem mnuSortClass = new MenuItem(mnuSortChildren, 8);
        mnuSortClass.setText("Class Name");
        mnuSortClass.addSelectionListener((SelectionListener)new ObjectSorter(3));
        MenuItem mnuHideInternalCall = new MenuItem(toolChildrenMenu, 32);
        mnuHideInternalCall.setText("Hide Internal Method Calls");
        SetHideInternalCallMenu handler = new SetHideInternalCallMenu(mnuHideInternalCall);
        mnuHideInternalCall.addSelectionListener((SelectionListener)handler);
        toolChildrenMenu.addMenuListener((MenuListener)handler);
        MenuItem mnuDominanceAnalysis = new MenuItem(toolChildrenMenu, 8);
        mnuDominanceAnalysis.setText("Apply dominance analysis");
        mnuDominanceAnalysis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.diagramView.getDominanceAnalysisCommand().execute();
            }
        });
        final MenuItem mnuLoadTimeDominanceAnalysis = new MenuItem(toolChildrenMenu, 32);
        mnuLoadTimeDominanceAnalysis.setText("Load-time dominance analysis");
        mnuLoadTimeDominanceAnalysis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.diagramView.setUseDominanceFilter(mnuLoadTimeDominanceAnalysis.getSelection());
            }
        });
    }

    private class CompactionMenu
    extends SelectionAdapter {
        private ICompactionCommand command;

        public CompactionMenu(int ruleNumber) {
            this.command = ViewerWindow.this.diagramView.getCompactionProcess(ruleNumber);
        }

        public void widgetSelected(SelectionEvent e) {
            this.command.execute();
        }
    }

    private class ObjectSorter
    extends SelectionAdapter {
        private int kind;

        public ObjectSorter(int kind) {
            this.kind = kind;
        }

        public void widgetSelected(SelectionEvent e) {
            ViewerWindow.this.diagramView.sortObjects(this.kind);
        }
    }

    private class SetHideInternalCallMenu
    extends MenuAdapter
    implements SelectionListener {
        private IStatefulAmidaCommand command;
        private MenuItem menuItem;

        public SetHideInternalCallMenu(MenuItem menu) {
            this.command = ViewerWindow.this.diagramView.getHideInternalCallCommand();
            this.menuItem = menu;
        }

        public void menuShown(MenuEvent e) {
            this.menuItem.setSelection(this.command.getMenuState());
        }

        public void widgetSelected(SelectionEvent arg0) {
            this.command.execute();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    }
}

