/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.filter.IDMatcher;
import junit.framework.TestCase;

public class IDMatcherTest
extends TestCase {
    public void testMatchEmpty() {
        IDMatcher matcher = new IDMatcher("");
        IDMatcherTest.assertTrue((boolean)matcher.match(0));
        IDMatcherTest.assertTrue((boolean)matcher.match(100));
    }

    public void testMatchEmptyWithArray() {
        IDMatcher matcher = new IDMatcher("");
        IDMatcherTest.assertFalse((boolean)matcher.match(new int[0]));
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 100;
        IDMatcherTest.assertTrue((boolean)matcher.match(nArray));
        IDMatcherTest.assertTrue((boolean)matcher.match(new int[]{1}));
    }

    public void testMatch() {
        IDMatcher matcher = new IDMatcher("1-10");
        IDMatcherTest.assertTrue((boolean)matcher.match(1));
        IDMatcherTest.assertTrue((boolean)matcher.match(10));
        IDMatcherTest.assertTrue((boolean)matcher.match(5));
        IDMatcherTest.assertFalse((boolean)matcher.match(0));
        IDMatcherTest.assertFalse((boolean)matcher.match(11));
    }

    public void testMatchArray() {
        IDMatcher matcher = new IDMatcher("1-10");
        IDMatcherTest.assertTrue((boolean)matcher.match(new int[]{1}));
        IDMatcherTest.assertTrue((boolean)matcher.match(new int[]{10}));
        IDMatcherTest.assertTrue((boolean)matcher.match(new int[]{5}));
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 100;
        IDMatcherTest.assertTrue((boolean)matcher.match(nArray));
        int[] nArray2 = new int[4];
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 100;
        IDMatcherTest.assertTrue((boolean)matcher.match(nArray2));
        IDMatcherTest.assertFalse((boolean)matcher.match(new int[1]));
        IDMatcherTest.assertFalse((boolean)matcher.match(new int[]{11}));
        int[] nArray3 = new int[2];
        nArray3[1] = 11;
        IDMatcherTest.assertFalse((boolean)matcher.match(nArray3));
        IDMatcherTest.assertFalse((boolean)matcher.match(new int[0]));
    }

    public void testMatchSingleNumber() {
        IDMatcher matcher = new IDMatcher("100");
        IDMatcherTest.assertTrue((boolean)matcher.match(100));
        IDMatcherTest.assertFalse((boolean)matcher.match(99));
        IDMatcherTest.assertFalse((boolean)matcher.match(101));
    }

    public void testMatchSingleNumberWithArray() {
        IDMatcher matcher = new IDMatcher("100");
        IDMatcherTest.assertTrue((boolean)matcher.match(new int[]{100}));
        int[] nArray = new int[5];
        nArray[1] = 99;
        nArray[2] = 100;
        nArray[3] = 101;
        nArray[4] = 1000;
        IDMatcherTest.assertTrue((boolean)matcher.match(nArray));
        int[] nArray2 = new int[4];
        nArray2[1] = 99;
        nArray2[2] = 101;
        nArray2[3] = 1000;
        IDMatcherTest.assertFalse((boolean)matcher.match(nArray2));
        IDMatcherTest.assertFalse((boolean)matcher.match(new int[]{99}));
        IDMatcherTest.assertFalse((boolean)matcher.match(new int[]{101}));
    }

    public void testMatchComplexPattern() {
        IDMatcher matcher = new IDMatcher("1-10, 29,50-");
        IDMatcherTest.assertTrue((boolean)matcher.match(1));
        IDMatcherTest.assertTrue((boolean)matcher.match(10));
        IDMatcherTest.assertFalse((boolean)matcher.match(11));
        IDMatcherTest.assertFalse((boolean)matcher.match(28));
        IDMatcherTest.assertTrue((boolean)matcher.match(29));
        IDMatcherTest.assertFalse((boolean)matcher.match(30));
        IDMatcherTest.assertTrue((boolean)matcher.match(50));
        IDMatcherTest.assertTrue((boolean)matcher.match(Integer.MAX_VALUE));
    }

    public void testMatchComplexPatternWithArray() {
        IDMatcher matcher = new IDMatcher("1-10, 29,50-");
        IDMatcherTest.assertTrue((boolean)matcher.match(new int[]{1, 17, 40}));
        int[] nArray = new int[7];
        nArray[1] = 11;
        nArray[2] = 12;
        nArray[3] = 28;
        nArray[4] = 30;
        nArray[5] = 40;
        nArray[6] = 49;
        IDMatcherTest.assertFalse((boolean)matcher.match(nArray));
        IDMatcherTest.assertTrue((boolean)matcher.match(new int[]{100}));
    }
}

