/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.filter.StringMatcher;
import junit.framework.TestCase;

public class StringMatcherTest
extends TestCase {
    public void testMatchBasic() {
        StringMatcher matcher = new StringMatcher("java.hoge.Main");
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.Main"));
        StringMatcherTest.assertFalse((boolean)matcher.match("java.hoge.Main2"));
        StringMatcherTest.assertFalse((boolean)matcher.match(" java.hoge.Main"));
    }

    public void testMatchSingleWildcard() {
        StringMatcher matcher = new StringMatcher("*");
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.main"));
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.test"));
        StringMatcherTest.assertTrue((boolean)matcher.match(""));
    }

    public void testMatchEmptyString() {
        StringMatcher matcher = new StringMatcher("");
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.main"));
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.test"));
        StringMatcherTest.assertTrue((boolean)matcher.match(""));
    }

    public void testMatchHeadWildcard() {
        StringMatcher matcher = new StringMatcher("*Main");
        StringMatcherTest.assertTrue((boolean)matcher.match("Main"));
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.Main"));
        StringMatcherTest.assertTrue((boolean)matcher.match("TestMain"));
        StringMatcherTest.assertFalse((boolean)matcher.match("java.hoge.MainStream"));
    }

    public void testMatchTailWildcard() {
        StringMatcher matcher = new StringMatcher("java.hoge.Main*");
        StringMatcherTest.assertFalse((boolean)matcher.match("java.hoge."));
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.Main"));
        assert (matcher.match("java.hoge.MainStream"));
    }

    public void testMatchWildcard() {
        StringMatcher matcher = new StringMatcher("java.*.Main");
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.Main"));
        StringMatcherTest.assertFalse((boolean)matcher.match("java.hoge.MainStream"));
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.fuga.Main"));
        StringMatcherTest.assertFalse((boolean)matcher.match("java.hoge.main"));
        StringMatcherTest.assertFalse((boolean)matcher.match("java.hoge.test"));
        matcher = new StringMatcher("java.*.*.Main");
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.fuga.Main"));
        StringMatcherTest.assertFalse((boolean)matcher.match("java.hoge.Main"));
        matcher = new StringMatcher("java*Main");
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.fuga.Main"));
        StringMatcherTest.assertTrue((boolean)matcher.match("java.hoge.Main"));
    }
}

