/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.flexible_log;

import amida.agent.flexible_log.DamidaFlexiblePrinter;
import amida.agent.flexible_log.DamidaXMLContext;
import amida.agent.flexible_log.DamidaXMLParser;
import amida.agent.logging_tf.DamidaOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import javassist.NotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DamidaFlexibleOutputStream<T>
extends DamidaOutputStream<T>
implements Runnable,
DamidaXMLParser {
    protected DamidaFlexiblePrinter<T> tmpPrinter;
    protected Thread exit;
    protected boolean serialize;
    protected TreeMap<Long, DamidaFlexiblePrinter<T>> map;

    public void setSerialize(boolean serialize) {
        this.serialize = serialize;
    }

    public DamidaFlexibleOutputStream(DamidaFlexiblePrinter<T> tmpPrinter) {
        this.tmpPrinter = tmpPrinter;
        this.map = new TreeMap();
        this.timeStamp = 0L;
        this.exit = new Thread(this);
        this.exit.setName(this.getClass().getName());
        Runtime.getRuntime().addShutdownHook(this.exit);
        this.setSerialize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DamidaFlexiblePrinter<T> getPrinter(long id, String name) {
        Object printer = null;
        TreeMap<Long, DamidaFlexiblePrinter<T>> treeMap = this.map;
        synchronized (treeMap) {
            printer = this.map.get(id);
            if (printer == null) {
                printer = this.tmpPrinter.clone();
                if (id == 0L || !this.serialize) {
                    try {
                        ((DamidaFlexiblePrinter)printer).openOutputStream(this.getLogDir(), name);
                    }
                    catch (NotFoundException e) {
                        System.err.println("! : Log file can't be created.");
                    }
                    catch (IOException e) {
                        System.err.println("! : Log file can't be created.");
                    }
                } else {
                    if (!this.tmpPrinter.isOpenOutputStream()) {
                        try {
                            this.tmpPrinter.openOutputStream(this.getLogDir(), "trace");
                        }
                        catch (NotFoundException e) {
                            System.err.println("! : Serialize Log file can't be created.");
                        }
                        catch (IOException e) {
                            System.err.println("! : Serialize Log file can't be created.");
                        }
                    }
                    ((DamidaFlexiblePrinter)printer).copyOutputStream(this.tmpPrinter);
                }
                ((DamidaFlexiblePrinter)printer).doFirst();
                this.map.put(id, (DamidaFlexiblePrinter<T>)printer);
            }
        }
        return printer;
    }

    public DamidaFlexiblePrinter<T> getPrinter() {
        return this.getPrinter(Thread.currentThread().getId(), null);
    }

    public DamidaFlexiblePrinter<T> getMetaPrinter() {
        return this.getPrinter(0L, "meta");
    }

    @Override
    public void addLg(T log) {
        try {
            this.getPrinter().writeOutputStream(log);
        }
        catch (IOException e) {
            System.err.println("! : Log file can't be writed.");
        }
    }

    @Override
    public void flushAll() {
        Iterator<DamidaFlexiblePrinter<T>> it = this.map.values().iterator();
        try {
            while (it.hasNext()) {
                it.next().flushOutputStream();
            }
        }
        catch (IOException e) {
            System.err.println("! : Log file can't be flushed.");
        }
    }

    @Override
    public void closeAll() {
        Iterator<DamidaFlexiblePrinter<T>> it = this.map.values().iterator();
        while (it.hasNext()) {
            it.next().doFinal();
        }
        it = this.map.values().iterator();
        try {
            while (it.hasNext()) {
                it.next().closeOutputStream();
            }
        }
        catch (IOException e) {
            System.err.println("! : Log file can't be closed.");
        }
    }

    @Override
    public void run() {
        this.closeAll();
        System.out.println("* : Logging complete!!");
    }

    @Override
    public void parse(Node n) {
        NodeList list = n.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            String tag = o.getNodeName();
            if (tag.equals(DamidaXMLContext.OUT_NAMES[1])) {
                this.tmpPrinter.gzip = ((Element)o).getAttribute("type").equals("zip");
                this.setSerialize(((Element)o).getAttribute("serialize").equals("on"));
            }
            ++i;
        }
    }

    @Override
    public Node create(Document doc) {
        Element n = doc.createElement(DamidaXMLContext.OUT_NAMES[0]);
        this.tmpPrinter.create(doc);
        return n;
    }
}

