/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.logging_tf;

import amida.agent.logging_tf.DamidaFormat;
import amida.agent.logging_tf.DamidaOutputStream;
import amida.agent.logging_tf.DamidaPermission;
import amida.agent.logging_tf.DamidaTrigger;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;

public abstract class DamidaLog<T> {
    protected DamidaOutputStream<T> out;
    protected DamidaTrigger trg;
    protected DamidaFormat fmt;
    protected DamidaPermission prm;

    public abstract void setting(String var1);

    public DamidaLog() {
    }

    public DamidaLog(DamidaOutputStream<T> out, DamidaTrigger trg, DamidaFormat fmt, DamidaPermission prm) {
        this.out = out;
        this.trg = trg;
        this.fmt = fmt;
        this.prm = prm;
    }

    public void init(String setting_file, String log_dir) {
        this.out.setLogDir(log_dir);
        this.setting(setting_file);
    }

    public long getTimeStamp() {
        return this.out.getTimeStamp();
    }

    public void addLg(T log) {
        this.out.addLg(log);
    }

    public void flushAll() {
        this.out.flushAll();
    }

    public void closeAll() {
        this.out.closeAll();
    }

    public boolean isLgInClass(String class_name) {
        return this.prm.canLgInClass(class_name);
    }

    public boolean isLgInConstructor(CtConstructor c) {
        return this.prm.canLgInConstructor(c);
    }

    public boolean isLgInMethod(CtMethod c) {
        return this.prm.canLgInMethod(c);
    }

    public boolean isLgConstructorCall(ConstructorCall c) {
        return this.prm.canLgConstructorCall(c);
    }

    public boolean isLgMethodCall(MethodCall c) {
        return this.prm.canLgMethodCall(c);
    }

    public boolean isLgFieldAccess(FieldAccess c) {
        return this.prm.canLgFieldAccess(c);
    }

    public boolean isLgCast(Cast c) {
        return this.prm.canLgCast(c);
    }

    public boolean isLgInstanceof(Instanceof c) {
        return this.prm.canLgInstanceof(c);
    }

    public boolean isLgHandler(Handler c) {
        return this.prm.canLgHandler(c);
    }

    public boolean isLgNewArray(NewArray c) {
        return this.prm.canLgNewArray(c);
    }

    public boolean isLgNewExpr(NewExpr c) {
        return this.prm.canLgNewExpr(c);
    }

    protected String[] insertTrgCodes(String[] codes, String[] trgCodes) {
        if (codes == null) {
            return null;
        }
        if (trgCodes == null) {
            trgCodes = new String[]{"", ""};
        }
        int n = codes.length - 1;
        codes[0] = "{" + trgCodes[0] + codes[0] + "}";
        if (n > 1) {
            codes[1] = "{" + codes[1] + "}";
        }
        codes[n] = "{" + codes[n] + trgCodes[1] + "}";
        return codes;
    }

    public String[] getLgConstructorInsertCode(CtConstructor c) {
        return this.insertTrgCodes(this.fmt.getLgConstructorInsertCode(c), this.trg.getTriggerInsertCode(this.trg.getTrgConstructorInsert(c)));
    }

    public String[] getLgMethodInsertCode(CtMethod c) {
        return this.insertTrgCodes(this.fmt.getLgMethodInsertCode(c), this.trg.getTriggerInsertCode(this.trg.getTrgMethodInsert(c)));
    }

    protected String insertTrgCodes(String code, String[] trgCodes) {
        if (code == null && trgCodes == null) {
            return null;
        }
        String tmp = code != null ? code : "$_=$proceed($$);";
        if (trgCodes == null) {
            return "{" + tmp + "}";
        }
        return "{" + trgCodes[0] + tmp + trgCodes[1] + "}";
    }

    public String getLgConstructorCallCode(ConstructorCall c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgConstructorCall(c));
        return this.insertTrgCodes(this.fmt.getLgConstructorCallCode(c), trgCodes);
    }

    public String getLgMethodCallCode(MethodCall c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgMethodCall(c));
        return this.insertTrgCodes(this.fmt.getLgMethodCallCode(c), trgCodes);
    }

    public String getLgFieldAccessCode(FieldAccess c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgFieldAccess(c));
        return this.insertTrgCodes(this.fmt.getLgFieldAccessCode(c), trgCodes);
    }

    public String getLgCastCode(Cast c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgCast(c));
        return this.insertTrgCodes(this.fmt.getLgCastCode(c), trgCodes);
    }

    public String getLgInstanceofCode(Instanceof c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgInstanceof(c));
        return this.insertTrgCodes(this.fmt.getLgInstanceofCode(c), trgCodes);
    }

    public String getLgHandlerCode(Handler c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgHandler(c));
        return this.insertTrgCodes(this.fmt.getLgHandlerCode(c), trgCodes);
    }

    public String getLgNewArrayCode(NewArray c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgNewArray(c));
        return this.insertTrgCodes(this.fmt.getLgNewArrayCode(c), trgCodes);
    }

    public String getLgNewExprCode(NewExpr c) {
        String[] trgCodes = this.trg.getTriggerCode(this.trg.getTrgNewExpr(c));
        return this.insertTrgCodes(this.fmt.getLgNewExprCode(c), trgCodes);
    }
}

