/*
 * Decompiled with CFR 0.152.
 */
package amida;

import amida.gui.MainFrame;
import java.io.File;
import java.util.ArrayList;

public class Main {
    public static void main(String[] args) {
        boolean inProcess = false;
        ArrayList<FileWithRange> loadFiles = new ArrayList<FileWithRange>();
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-inprocess")) {
                    inProcess = true;
                } else {
                    String[] tokens = args[i].split("\\*");
                    File f = new File(tokens[0]);
                    if (f.canRead()) {
                        int pbegin = -1;
                        int pend = -1;
                        File threadFile = null;
                        try {
                            if (tokens.length == 2) {
                                threadFile = new File(tokens[1]);
                                if (!threadFile.canRead()) {
                                    threadFile = null;
                                }
                            } else if (tokens.length == 3) {
                                pbegin = Integer.valueOf(tokens[1]);
                                pend = Integer.valueOf(tokens[2]);
                            } else if (tokens.length == 4) {
                                pbegin = Integer.valueOf(tokens[1]);
                                pend = Integer.valueOf(tokens[2]);
                                threadFile = new File(tokens[3]);
                                if (!threadFile.canRead()) {
                                    threadFile = null;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            pbegin = 0;
                            pend = 0;
                        }
                        loadFiles.add(new FileWithRange(f, pbegin, pend, threadFile));
                    }
                }
                ++i;
            }
        }
        MainFrame frame = MainFrame.getInstance();
        frame.pack();
        if (loadFiles.size() > 0) {
            for (FileWithRange f : loadFiles) {
                frame.loadFile(f.getFile(), f.getPBegin(), f.getPEnd(), f.getThreadFile());
            }
        }
        frame.setInprocess(inProcess);
        frame.setVisible(true);
    }

    private static class FileWithRange {
        private File file;
        private int pbegin;
        private int pend;
        private File threadFile;

        public FileWithRange(File f, int pbegin, int pend, File threadFile) {
            this.file = f;
            this.pbegin = pbegin;
            this.pend = pend;
            this.threadFile = threadFile;
        }

        public int getPBegin() {
            return this.pbegin;
        }

        public int getPEnd() {
            return this.pend;
        }

        public File getFile() {
            return this.file;
        }

        public File getThreadFile() {
            return this.threadFile;
        }
    }
}

