/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram;

import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.diagram.sequencediagram.ObjectGroup;
import amida.diagram.sequencediagram.SequenceObject;
import amida.diagram.sequencediagram.filter.IPreObjectFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectMap {
    private Map<CallNode, ObjectGroup> objectGroupeMap = new HashMap<CallNode, ObjectGroup>();
    private Map<Object, SequenceObject> objectMap = new HashMap<Object, SequenceObject>();

    public Object get(Object key) {
        if (!(key instanceof CallNode)) {
            return null;
        }
        return this.get((CallNode)key);
    }

    public SequenceObject get(CallNode call) {
        ObjectGroup groupe = this.objectGroupeMap.get(call);
        if (groupe != null) {
            SequenceObject object = groupe.getSequenceObject();
            return object;
        }
        Integer id = call.getId().iterator().next();
        Object key = id;
        if (id == 0) {
            key = call.getFullClassName();
        }
        return this.objectMap.get(key);
    }

    public void clear() {
        this.objectGroupeMap.clear();
        this.objectMap.clear();
    }

    public void makeObjectGroupes(NodeList nodes, List<IPreObjectFilter> filters) {
        CallTreeIterator nit = nodes.nodeIterator();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            this.makeObjectGroupes(node, filters);
        }
    }

    public void makeObjectGroupes(Node node, List<IPreObjectFilter> filters) {
        if (node instanceof CallNode) {
            CallNode call = (CallNode)node;
            boolean filtered = false;
            for (IPreObjectFilter filter : filters) {
                if (!filter.filter(call)) continue;
                filter.makeSuitableGroupe(call, this.objectGroupeMap);
                filtered = true;
            }
            if (!filtered) {
                Set<Integer> idSet = call.getId();
                if (idSet.size() > 1) {
                    Collection<ObjectGroup> groupes = this.objectGroupeMap.values();
                    boolean exist = false;
                    for (ObjectGroup groupe : groupes) {
                        if (!idSet.equals(groupe.getIds())) continue;
                        this.objectGroupeMap.put(call, groupe);
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        ObjectGroup groupe = new ObjectGroup(call);
                        this.objectGroupeMap.put(call, groupe);
                    }
                } else {
                    Integer id = idSet.iterator().next();
                    Object key = id;
                    if (id == 0) {
                        key = call.getFullClassName();
                    }
                    this.objectMap.put(key, new SequenceObject(call));
                }
            }
        }
        CallTreeIterator it = node.nodeIterator();
        while (it.hasNext()) {
            this.makeObjectGroupes(it.nextNode(), filters);
        }
    }
}

